package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{SmbUser, SmbPassword, SmbDomain}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FsxProtocolSmb(
    domain: Optional[SmbDomain] = Optional.Absent,
    mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions] =
      Optional.Absent,
    password: SmbPassword,
    user: SmbUser
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.FsxProtocolSmb = {
    import FsxProtocolSmb.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.FsxProtocolSmb
      .builder()
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .password(SmbPassword.unwrap(password): java.lang.String)
      .user(SmbUser.unwrap(user): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.FsxProtocolSmb.ReadOnly =
    zio.aws.datasync.model.FsxProtocolSmb.wrap(buildAwsValue())
}
object FsxProtocolSmb {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.FsxProtocolSmb
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.FsxProtocolSmb =
      zio.aws.datasync.model.FsxProtocolSmb(
        domain.map(value => value),
        mountOptions.map(value => value.asEditable),
        password,
        user
      )
    def domain: Optional[SmbDomain]
    def mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly]
    def password: SmbPassword
    def user: SmbUser
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getPassword: ZIO[Any, Nothing, SmbPassword] = ZIO.succeed(password)
    def getUser: ZIO[Any, Nothing, SmbUser] = ZIO.succeed(user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.FsxProtocolSmb
  ) extends zio.aws.datasync.model.FsxProtocolSmb.ReadOnly {
    override val domain: Optional[SmbDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
    override val mountOptions
        : Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountOptions())
        .map(value => zio.aws.datasync.model.SmbMountOptions.wrap(value))
    override val password: SmbPassword =
      zio.aws.datasync.model.primitives.SmbPassword(impl.password())
    override val user: SmbUser =
      zio.aws.datasync.model.primitives.SmbUser(impl.user())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.FsxProtocolSmb
  ): zio.aws.datasync.model.FsxProtocolSmb.ReadOnly = new Wrapper(impl)
}
