package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait Operator {
  def unwrap: software.amazon.awssdk.services.datasync.model.Operator
}
object Operator {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.Operator
  ): zio.aws.datasync.model.Operator = value match {
    case software.amazon.awssdk.services.datasync.model.Operator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.Operator.EQUALS =>
      val r = Equals
      r
    case software.amazon.awssdk.services.datasync.model.Operator.NOT_EQUALS =>
      val r = NotEquals
      r
    case software.amazon.awssdk.services.datasync.model.Operator.IN =>
      val r = In
      r
    case software.amazon.awssdk.services.datasync.model.Operator.LESS_THAN_OR_EQUAL =>
      val r = LessThanOrEqual
      r
    case software.amazon.awssdk.services.datasync.model.Operator.LESS_THAN =>
      val r = LessThan
      r
    case software.amazon.awssdk.services.datasync.model.Operator.GREATER_THAN_OR_EQUAL =>
      val r = GreaterThanOrEqual
      r
    case software.amazon.awssdk.services.datasync.model.Operator.GREATER_THAN =>
      val r = GreaterThan
      r
    case software.amazon.awssdk.services.datasync.model.Operator.CONTAINS =>
      val r = Contains
      r
    case software.amazon.awssdk.services.datasync.model.Operator.NOT_CONTAINS =>
      val r = NotContains
      r
    case software.amazon.awssdk.services.datasync.model.Operator.BEGINS_WITH =>
      val r = BeginsWith
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.UNKNOWN_TO_SDK_VERSION
  }
  case object Equals extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.EQUALS
  }
  case object NotEquals extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.NOT_EQUALS
  }
  case object In extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.IN
  }
  case object LessThanOrEqual extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.LESS_THAN_OR_EQUAL
  }
  case object LessThan extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.LESS_THAN
  }
  case object GreaterThanOrEqual extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.GREATER_THAN_OR_EQUAL
  }
  case object GreaterThan extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.GREATER_THAN
  }
  case object Contains extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.CONTAINS
  }
  case object NotContains extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.NOT_CONTAINS
  }
  case object BeginsWith extends zio.aws.datasync.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.Operator =
      software.amazon.awssdk.services.datasync.model.Operator.BEGINS_WITH
  }
}
