package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Ec2SecurityGroupArn,
  Time,
  LocationArn,
  FsxFilesystemArn,
  StorageVirtualMachineArn,
  LocationUri
}
import scala.jdk.CollectionConverters.*
final case class DescribeLocationFsxOntapResponse(
    creationTime: Optional[Time] = Optional.Absent,
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    protocol: Optional[zio.aws.datasync.model.FsxProtocol] = Optional.Absent,
    securityGroupArns: Optional[Iterable[Ec2SecurityGroupArn]] =
      Optional.Absent,
    storageVirtualMachineArn: Optional[StorageVirtualMachineArn] =
      Optional.Absent,
    fsxFilesystemArn: Optional[FsxFilesystemArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapResponse = {
    import DescribeLocationFsxOntapResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapResponse
      .builder()
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(protocol.map(value => value.buildAwsValue()))(_.protocol)
      .optionallyWith(
        securityGroupArns.map(value =>
          value.map { item =>
            Ec2SecurityGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupArns)
      .optionallyWith(
        storageVirtualMachineArn.map(value =>
          StorageVirtualMachineArn.unwrap(value): java.lang.String
        )
      )(_.storageVirtualMachineArn)
      .optionallyWith(
        fsxFilesystemArn.map(value =>
          FsxFilesystemArn.unwrap(value): java.lang.String
        )
      )(_.fsxFilesystemArn)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationFsxOntapResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationFsxOntapResponse
      .wrap(buildAwsValue())
}
object DescribeLocationFsxOntapResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationFsxOntapResponse =
      zio.aws.datasync.model.DescribeLocationFsxOntapResponse(
        creationTime.map(value => value),
        locationArn.map(value => value),
        locationUri.map(value => value),
        protocol.map(value => value.asEditable),
        securityGroupArns.map(value => value),
        storageVirtualMachineArn.map(value => value),
        fsxFilesystemArn.map(value => value)
      )
    def creationTime: Optional[Time]
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def protocol: Optional[zio.aws.datasync.model.FsxProtocol.ReadOnly]
    def securityGroupArns: Optional[List[Ec2SecurityGroupArn]]
    def storageVirtualMachineArn: Optional[StorageVirtualMachineArn]
    def fsxFilesystemArn: Optional[FsxFilesystemArn]
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.datasync.model.FsxProtocol.ReadOnly] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getSecurityGroupArns: ZIO[Any, AwsError, List[Ec2SecurityGroupArn]] =
      AwsError.unwrapOptionField("securityGroupArns", securityGroupArns)
    def getStorageVirtualMachineArn
        : ZIO[Any, AwsError, StorageVirtualMachineArn] = AwsError
      .unwrapOptionField("storageVirtualMachineArn", storageVirtualMachineArn)
    def getFsxFilesystemArn: ZIO[Any, AwsError, FsxFilesystemArn] =
      AwsError.unwrapOptionField("fsxFilesystemArn", fsxFilesystemArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapResponse
  ) extends zio.aws.datasync.model.DescribeLocationFsxOntapResponse.ReadOnly {
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val protocol
        : Optional[zio.aws.datasync.model.FsxProtocol.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.datasync.model.FsxProtocol.wrap(value))
    override val securityGroupArns: Optional[List[Ec2SecurityGroupArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
          }.toList
        )
    override val storageVirtualMachineArn: Optional[StorageVirtualMachineArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageVirtualMachineArn())
        .map(value =>
          zio.aws.datasync.model.primitives.StorageVirtualMachineArn(value)
        )
    override val fsxFilesystemArn: Optional[FsxFilesystemArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fsxFilesystemArn())
        .map(value => zio.aws.datasync.model.primitives.FsxFilesystemArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapResponse
  ): zio.aws.datasync.model.DescribeLocationFsxOntapResponse.ReadOnly =
    new Wrapper(impl)
}
