package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  FsxOpenZfsSubdirectory,
  Ec2SecurityGroupArn,
  FsxFilesystemArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLocationFsxOpenZfsRequest(
    fsxFilesystemArn: FsxFilesystemArn,
    protocol: zio.aws.datasync.model.FsxProtocol,
    securityGroupArns: Iterable[Ec2SecurityGroupArn],
    subdirectory: Optional[FsxOpenZfsSubdirectory] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest = {
    import CreateLocationFsxOpenZfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest
      .builder()
      .fsxFilesystemArn(
        FsxFilesystemArn.unwrap(fsxFilesystemArn): java.lang.String
      )
      .protocol(protocol.buildAwsValue())
      .securityGroupArns(securityGroupArns.map { item =>
        Ec2SecurityGroupArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        subdirectory.map(value =>
          FsxOpenZfsSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationFsxOpenZfsRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationFsxOpenZfsRequest.wrap(buildAwsValue())
}
object CreateLocationFsxOpenZfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationFsxOpenZfsRequest =
      zio.aws.datasync.model.CreateLocationFsxOpenZfsRequest(
        fsxFilesystemArn,
        protocol.asEditable,
        securityGroupArns,
        subdirectory.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fsxFilesystemArn: FsxFilesystemArn
    def protocol: zio.aws.datasync.model.FsxProtocol.ReadOnly
    def securityGroupArns: List[Ec2SecurityGroupArn]
    def subdirectory: Optional[FsxOpenZfsSubdirectory]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getFsxFilesystemArn: ZIO[Any, Nothing, FsxFilesystemArn] =
      ZIO.succeed(fsxFilesystemArn)
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.datasync.model.FsxProtocol.ReadOnly] =
      ZIO.succeed(protocol)
    def getSecurityGroupArns: ZIO[Any, Nothing, List[Ec2SecurityGroupArn]] =
      ZIO.succeed(securityGroupArns)
    def getSubdirectory: ZIO[Any, AwsError, FsxOpenZfsSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest
  ) extends zio.aws.datasync.model.CreateLocationFsxOpenZfsRequest.ReadOnly {
    override val fsxFilesystemArn: FsxFilesystemArn =
      zio.aws.datasync.model.primitives
        .FsxFilesystemArn(impl.fsxFilesystemArn())
    override val protocol: zio.aws.datasync.model.FsxProtocol.ReadOnly =
      zio.aws.datasync.model.FsxProtocol.wrap(impl.protocol())
    override val securityGroupArns: List[Ec2SecurityGroupArn] = impl
      .securityGroupArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
      }
      .toList
    override val subdirectory: Optional[FsxOpenZfsSubdirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdirectory())
        .map(value =>
          zio.aws.datasync.model.primitives.FsxOpenZfsSubdirectory(value)
        )
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest
  ): zio.aws.datasync.model.CreateLocationFsxOpenZfsRequest.ReadOnly =
    new Wrapper(impl)
}
