package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLocationsResponse(
    locations: Optional[Iterable[zio.aws.datasync.model.LocationListEntry]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListLocationsResponse = {
    import ListLocationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListLocationsResponse
      .builder()
      .optionallyWith(
        locations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListLocationsResponse.ReadOnly =
    zio.aws.datasync.model.ListLocationsResponse.wrap(buildAwsValue())
}
object ListLocationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListLocationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListLocationsResponse =
      zio.aws.datasync.model.ListLocationsResponse(
        locations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def locations
        : Optional[List[zio.aws.datasync.model.LocationListEntry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getLocations: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.LocationListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("locations", locations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListLocationsResponse
  ) extends zio.aws.datasync.model.ListLocationsResponse.ReadOnly {
    override val locations
        : Optional[List[zio.aws.datasync.model.LocationListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.LocationListEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListLocationsResponse
  ): zio.aws.datasync.model.ListLocationsResponse.ReadOnly = new Wrapper(impl)
}
