package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{TagValue, LogGroupArn, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTaskRequest(
    sourceLocationArn: LocationArn,
    destinationLocationArn: LocationArn,
    cloudWatchLogGroupArn: Optional[LogGroupArn] = Optional.Absent,
    name: Optional[TagValue] = Optional.Absent,
    options: Optional[zio.aws.datasync.model.Options] = Optional.Absent,
    excludes: Optional[Iterable[zio.aws.datasync.model.FilterRule]] =
      Optional.Absent,
    schedule: Optional[zio.aws.datasync.model.TaskSchedule] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent,
    includes: Optional[Iterable[zio.aws.datasync.model.FilterRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateTaskRequest = {
    import CreateTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateTaskRequest
      .builder()
      .sourceLocationArn(
        LocationArn.unwrap(sourceLocationArn): java.lang.String
      )
      .destinationLocationArn(
        LocationArn.unwrap(destinationLocationArn): java.lang.String
      )
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          LogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateTaskRequest.ReadOnly =
    zio.aws.datasync.model.CreateTaskRequest.wrap(buildAwsValue())
}
object CreateTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateTaskRequest =
      zio.aws.datasync.model.CreateTaskRequest(
        sourceLocationArn,
        destinationLocationArn,
        cloudWatchLogGroupArn.map(value => value),
        name.map(value => value),
        options.map(value => value.asEditable),
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schedule.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceLocationArn: LocationArn
    def destinationLocationArn: LocationArn
    def cloudWatchLogGroupArn: Optional[LogGroupArn]
    def name: Optional[TagValue]
    def options: Optional[zio.aws.datasync.model.Options.ReadOnly]
    def excludes: Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def schedule: Optional[zio.aws.datasync.model.TaskSchedule.ReadOnly]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def includes: Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def getSourceLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(sourceLocationArn)
    def getDestinationLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(destinationLocationArn)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.Options.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getExcludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludes", excludes)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskSchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getIncludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateTaskRequest
  ) extends zio.aws.datasync.model.CreateTaskRequest.ReadOnly {
    override val sourceLocationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.sourceLocationArn())
    override val destinationLocationArn: LocationArn =
      zio.aws.datasync.model.primitives
        .LocationArn(impl.destinationLocationArn())
    override val cloudWatchLogGroupArn: Optional[LogGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupArn())
        .map(value => zio.aws.datasync.model.primitives.LogGroupArn(value))
    override val name: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val options: Optional[zio.aws.datasync.model.Options.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.datasync.model.Options.wrap(value))
    override val excludes
        : Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.FilterRule.wrap(item)
          }.toList
        )
    override val schedule
        : Optional[zio.aws.datasync.model.TaskSchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.datasync.model.TaskSchedule.wrap(value))
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
    override val includes
        : Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.FilterRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateTaskRequest
  ): zio.aws.datasync.model.CreateTaskRequest.ReadOnly = new Wrapper(impl)
}
