package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeLocationFsxLustreRequest(locationArn: LocationArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest = {
    import DescribeLocationFsxLustreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationFsxLustreRequest.ReadOnly =
    zio.aws.datasync.model.DescribeLocationFsxLustreRequest
      .wrap(buildAwsValue())
}
object DescribeLocationFsxLustreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationFsxLustreRequest =
      zio.aws.datasync.model.DescribeLocationFsxLustreRequest(locationArn)
    def locationArn: LocationArn
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest
  ) extends zio.aws.datasync.model.DescribeLocationFsxLustreRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest
  ): zio.aws.datasync.model.DescribeLocationFsxLustreRequest.ReadOnly =
    new Wrapper(impl)
}
