package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaggableResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: TaggableResourceArn,
    tags: Iterable[zio.aws.datasync.model.TagListEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TagResourceRequest
      .builder()
      .resourceArn(TaggableResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TagResourceRequest.ReadOnly =
    zio.aws.datasync.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TagResourceRequest =
      zio.aws.datasync.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: TaggableResourceArn
    def tags: List[zio.aws.datasync.model.TagListEntry.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, TaggableResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TagResourceRequest
  ) extends zio.aws.datasync.model.TagResourceRequest.ReadOnly {
    override val resourceArn: TaggableResourceArn =
      zio.aws.datasync.model.primitives.TaggableResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.datasync.model.TagListEntry.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.datasync.model.TagListEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TagResourceRequest
  ): zio.aws.datasync.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
