package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FsxProtocol(
    nfs: Optional[zio.aws.datasync.model.FsxProtocolNfs] = Optional.Absent,
    smb: Optional[zio.aws.datasync.model.FsxProtocolSmb] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.FsxProtocol = {
    import FsxProtocol.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.FsxProtocol
      .builder()
      .optionallyWith(nfs.map(value => value.buildAwsValue()))(_.nfs)
      .optionallyWith(smb.map(value => value.buildAwsValue()))(_.smb)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.FsxProtocol.ReadOnly =
    zio.aws.datasync.model.FsxProtocol.wrap(buildAwsValue())
}
object FsxProtocol {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.FsxProtocol
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.FsxProtocol =
      zio.aws.datasync.model.FsxProtocol(
        nfs.map(value => value.asEditable),
        smb.map(value => value.asEditable)
      )
    def nfs: Optional[zio.aws.datasync.model.FsxProtocolNfs.ReadOnly]
    def smb: Optional[zio.aws.datasync.model.FsxProtocolSmb.ReadOnly]
    def getNfs
        : ZIO[Any, AwsError, zio.aws.datasync.model.FsxProtocolNfs.ReadOnly] =
      AwsError.unwrapOptionField("nfs", nfs)
    def getSmb
        : ZIO[Any, AwsError, zio.aws.datasync.model.FsxProtocolSmb.ReadOnly] =
      AwsError.unwrapOptionField("smb", smb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.FsxProtocol
  ) extends zio.aws.datasync.model.FsxProtocol.ReadOnly {
    override val nfs: Optional[zio.aws.datasync.model.FsxProtocolNfs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfs())
        .map(value => zio.aws.datasync.model.FsxProtocolNfs.wrap(value))
    override val smb: Optional[zio.aws.datasync.model.FsxProtocolSmb.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smb())
        .map(value => zio.aws.datasync.model.FsxProtocolSmb.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.FsxProtocol
  ): zio.aws.datasync.model.FsxProtocol.ReadOnly = new Wrapper(impl)
}
