package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  SmbUser,
  Time,
  LocationArn,
  SmbDomain,
  LocationUri,
  AgentArn
}
import scala.jdk.CollectionConverters.*
final case class DescribeLocationSmbResponse(
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent,
    user: Optional[SmbUser] = Optional.Absent,
    domain: Optional[SmbDomain] = Optional.Absent,
    mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions] =
      Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse = {
    import DescribeLocationSmbResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(
        user.map(value => SmbUser.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationSmbResponse.wrap(buildAwsValue())
}
object DescribeLocationSmbResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationSmbResponse =
      zio.aws.datasync.model.DescribeLocationSmbResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        agentArns.map(value => value),
        user.map(value => value),
        domain.map(value => value),
        mountOptions.map(value => value.asEditable),
        creationTime.map(value => value)
      )
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def agentArns: Optional[List[AgentArn]]
    def user: Optional[SmbUser]
    def domain: Optional[SmbDomain]
    def mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly]
    def creationTime: Optional[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getUser: ZIO[Any, AwsError, SmbUser] =
      AwsError.unwrapOptionField("user", user)
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse
  ) extends zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val user: Optional[SmbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => zio.aws.datasync.model.primitives.SmbUser(value))
    override val domain: Optional[SmbDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
    override val mountOptions
        : Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountOptions())
        .map(value => zio.aws.datasync.model.SmbMountOptions.wrap(value))
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse
  ): zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly = new Wrapper(
    impl
  )
}
