package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait OverwriteMode {
  def unwrap: software.amazon.awssdk.services.datasync.model.OverwriteMode
}
object OverwriteMode {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.OverwriteMode
  ): zio.aws.datasync.model.OverwriteMode = value match {
    case software.amazon.awssdk.services.datasync.model.OverwriteMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.OverwriteMode.ALWAYS =>
      val r = ALWAYS
      r
    case software.amazon.awssdk.services.datasync.model.OverwriteMode.NEVER =>
      val r = NEVER
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.OverwriteMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.OverwriteMode =
      software.amazon.awssdk.services.datasync.model.OverwriteMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ALWAYS extends zio.aws.datasync.model.OverwriteMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.OverwriteMode =
      software.amazon.awssdk.services.datasync.model.OverwriteMode.ALWAYS
  }
  case object NEVER extends zio.aws.datasync.model.OverwriteMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.OverwriteMode =
      software.amazon.awssdk.services.datasync.model.OverwriteMode.NEVER
  }
}
