package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.AgentArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OnPremConfig(agentArns: Iterable[AgentArn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.OnPremConfig = {
    import OnPremConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.OnPremConfig
      .builder()
      .agentArns(agentArns.map { item =>
        AgentArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.OnPremConfig.ReadOnly =
    zio.aws.datasync.model.OnPremConfig.wrap(buildAwsValue())
}
object OnPremConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.OnPremConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.OnPremConfig =
      zio.aws.datasync.model.OnPremConfig(agentArns)
    def agentArns: List[AgentArn]
    def getAgentArns: ZIO[Any, Nothing, List[AgentArn]] = ZIO.succeed(agentArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.OnPremConfig
  ) extends zio.aws.datasync.model.OnPremConfig.ReadOnly {
    override val agentArns: List[AgentArn] = impl
      .agentArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.AgentArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.OnPremConfig
  ): zio.aws.datasync.model.OnPremConfig.ReadOnly = new Wrapper(impl)
}
