package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FsxProtocolNfs(
    mountOptions: Optional[zio.aws.datasync.model.NfsMountOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.FsxProtocolNfs = {
    import FsxProtocolNfs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.FsxProtocolNfs
      .builder()
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.FsxProtocolNfs.ReadOnly =
    zio.aws.datasync.model.FsxProtocolNfs.wrap(buildAwsValue())
}
object FsxProtocolNfs {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.FsxProtocolNfs
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.FsxProtocolNfs =
      zio.aws.datasync.model
        .FsxProtocolNfs(mountOptions.map(value => value.asEditable))
    def mountOptions: Optional[zio.aws.datasync.model.NfsMountOptions.ReadOnly]
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.NfsMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.FsxProtocolNfs
  ) extends zio.aws.datasync.model.FsxProtocolNfs.ReadOnly {
    override val mountOptions
        : Optional[zio.aws.datasync.model.NfsMountOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountOptions())
        .map(value => zio.aws.datasync.model.NfsMountOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.FsxProtocolNfs
  ): zio.aws.datasync.model.FsxProtocolNfs.ReadOnly = new Wrapper(impl)
}
