package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeTaskRequest(taskArn: TaskArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeTaskRequest = {
    import DescribeTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeTaskRequest
      .builder()
      .taskArn(TaskArn.unwrap(taskArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeTaskRequest.ReadOnly =
    zio.aws.datasync.model.DescribeTaskRequest.wrap(buildAwsValue())
}
object DescribeTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeTaskRequest =
      zio.aws.datasync.model.DescribeTaskRequest(taskArn)
    def taskArn: TaskArn
    def getTaskArn: ZIO[Any, Nothing, TaskArn] = ZIO.succeed(taskArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskRequest
  ) extends zio.aws.datasync.model.DescribeTaskRequest.ReadOnly {
    override val taskArn: TaskArn =
      zio.aws.datasync.model.primitives.TaskArn(impl.taskArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskRequest
  ): zio.aws.datasync.model.DescribeTaskRequest.ReadOnly = new Wrapper(impl)
}
