package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{Ec2SecurityGroupArn, Ec2SubnetArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Ec2Config(
    subnetArn: Ec2SubnetArn,
    securityGroupArns: Iterable[Ec2SecurityGroupArn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.Ec2Config = {
    import Ec2Config.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.Ec2Config
      .builder()
      .subnetArn(Ec2SubnetArn.unwrap(subnetArn): java.lang.String)
      .securityGroupArns(securityGroupArns.map { item =>
        Ec2SecurityGroupArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.Ec2Config.ReadOnly =
    zio.aws.datasync.model.Ec2Config.wrap(buildAwsValue())
}
object Ec2Config {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.Ec2Config
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.Ec2Config =
      zio.aws.datasync.model.Ec2Config(subnetArn, securityGroupArns)
    def subnetArn: Ec2SubnetArn
    def securityGroupArns: List[Ec2SecurityGroupArn]
    def getSubnetArn: ZIO[Any, Nothing, Ec2SubnetArn] = ZIO.succeed(subnetArn)
    def getSecurityGroupArns: ZIO[Any, Nothing, List[Ec2SecurityGroupArn]] =
      ZIO.succeed(securityGroupArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.Ec2Config
  ) extends zio.aws.datasync.model.Ec2Config.ReadOnly {
    override val subnetArn: Ec2SubnetArn =
      zio.aws.datasync.model.primitives.Ec2SubnetArn(impl.subnetArn())
    override val securityGroupArns: List[Ec2SecurityGroupArn] = impl
      .securityGroupArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.Ec2Config
  ): zio.aws.datasync.model.Ec2Config.ReadOnly = new Wrapper(impl)
}
