package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.FilterAttributeValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LocationFilter(
    name: zio.aws.datasync.model.LocationFilterName,
    values: Iterable[FilterAttributeValue],
    operator: zio.aws.datasync.model.Operator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.LocationFilter = {
    import LocationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.LocationFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterAttributeValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.LocationFilter.ReadOnly =
    zio.aws.datasync.model.LocationFilter.wrap(buildAwsValue())
}
object LocationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.LocationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.LocationFilter =
      zio.aws.datasync.model.LocationFilter(name, values, operator)
    def name: zio.aws.datasync.model.LocationFilterName
    def values: List[FilterAttributeValue]
    def operator: zio.aws.datasync.model.Operator
    def getName: ZIO[Any, Nothing, zio.aws.datasync.model.LocationFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterAttributeValue]] =
      ZIO.succeed(values)
    def getOperator: ZIO[Any, Nothing, zio.aws.datasync.model.Operator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.LocationFilter
  ) extends zio.aws.datasync.model.LocationFilter.ReadOnly {
    override val name: zio.aws.datasync.model.LocationFilterName =
      zio.aws.datasync.model.LocationFilterName.wrap(impl.name())
    override val values: List[FilterAttributeValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.FilterAttributeValue(item)
      }
      .toList
    override val operator: zio.aws.datasync.model.Operator =
      zio.aws.datasync.model.Operator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.LocationFilter
  ): zio.aws.datasync.model.LocationFilter.ReadOnly = new Wrapper(impl)
}
