package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{EfsFilesystemArn, EfsSubdirectory}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLocationEfsRequest(
    subdirectory: Optional[EfsSubdirectory] = Optional.Absent,
    efsFilesystemArn: EfsFilesystemArn,
    ec2Config: zio.aws.datasync.model.Ec2Config,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest = {
    import CreateLocationEfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest
      .builder()
      .optionallyWith(
        subdirectory.map(value =>
          EfsSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .efsFilesystemArn(
        EfsFilesystemArn.unwrap(efsFilesystemArn): java.lang.String
      )
      .ec2Config(ec2Config.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateLocationEfsRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationEfsRequest.wrap(buildAwsValue())
}
object CreateLocationEfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationEfsRequest =
      zio.aws.datasync.model.CreateLocationEfsRequest(
        subdirectory.map(value => value),
        efsFilesystemArn,
        ec2Config.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subdirectory: Optional[EfsSubdirectory]
    def efsFilesystemArn: EfsFilesystemArn
    def ec2Config: zio.aws.datasync.model.Ec2Config.ReadOnly
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getSubdirectory: ZIO[Any, AwsError, EfsSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getEfsFilesystemArn: ZIO[Any, Nothing, EfsFilesystemArn] =
      ZIO.succeed(efsFilesystemArn)
    def getEc2Config
        : ZIO[Any, Nothing, zio.aws.datasync.model.Ec2Config.ReadOnly] =
      ZIO.succeed(ec2Config)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest
  ) extends zio.aws.datasync.model.CreateLocationEfsRequest.ReadOnly {
    override val subdirectory: Optional[EfsSubdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.EfsSubdirectory(value))
    override val efsFilesystemArn: EfsFilesystemArn =
      zio.aws.datasync.model.primitives
        .EfsFilesystemArn(impl.efsFilesystemArn())
    override val ec2Config: zio.aws.datasync.model.Ec2Config.ReadOnly =
      zio.aws.datasync.model.Ec2Config.wrap(impl.ec2Config())
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest
  ): zio.aws.datasync.model.CreateLocationEfsRequest.ReadOnly = new Wrapper(
    impl
  )
}
