package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  NextToken,
  MaxResults,
  TaggableResourceArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    resourceArn: TaggableResourceArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(TaggableResourceArn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.datasync.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListTagsForResourceRequest =
      zio.aws.datasync.model.ListTagsForResourceRequest(
        resourceArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceArn: TaggableResourceArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getResourceArn: ZIO[Any, Nothing, TaggableResourceArn] =
      ZIO.succeed(resourceArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest
  ) extends zio.aws.datasync.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: TaggableResourceArn =
      zio.aws.datasync.model.primitives.TaggableResourceArn(impl.resourceArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datasync.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest
  ): zio.aws.datasync.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
