package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{NextToken, MaxResults, TaskArn}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTaskExecutionsRequest(
    taskArn: Optional[TaskArn] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest = {
    import ListTaskExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest
      .builder()
      .optionallyWith(
        taskArn.map(value => TaskArn.unwrap(value): java.lang.String)
      )(_.taskArn)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListTaskExecutionsRequest.ReadOnly =
    zio.aws.datasync.model.ListTaskExecutionsRequest.wrap(buildAwsValue())
}
object ListTaskExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListTaskExecutionsRequest =
      zio.aws.datasync.model.ListTaskExecutionsRequest(
        taskArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def taskArn: Optional[TaskArn]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getTaskArn: ZIO[Any, AwsError, TaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest
  ) extends zio.aws.datasync.model.ListTaskExecutionsRequest.ReadOnly {
    override val taskArn: Optional[TaskArn] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArn())
      .map(value => zio.aws.datasync.model.primitives.TaskArn(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datasync.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest
  ): zio.aws.datasync.model.ListTaskExecutionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
