package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  Ec2SecurityGroupArn,
  ActivationKey,
  TagValue,
  Ec2SubnetArn,
  VpcEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAgentRequest(
    activationKey: ActivationKey,
    agentName: Optional[TagValue] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent,
    vpcEndpointId: Optional[VpcEndpointId] = Optional.Absent,
    subnetArns: Optional[Iterable[Ec2SubnetArn]] = Optional.Absent,
    securityGroupArns: Optional[Iterable[Ec2SecurityGroupArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateAgentRequest = {
    import CreateAgentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateAgentRequest
      .builder()
      .activationKey(ActivationKey.unwrap(activationKey): java.lang.String)
      .optionallyWith(
        agentName.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.agentName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(
        subnetArns.map(value =>
          value.map { item =>
            Ec2SubnetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetArns)
      .optionallyWith(
        securityGroupArns.map(value =>
          value.map { item =>
            Ec2SecurityGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupArns)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateAgentRequest.ReadOnly =
    zio.aws.datasync.model.CreateAgentRequest.wrap(buildAwsValue())
}
object CreateAgentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateAgentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateAgentRequest =
      zio.aws.datasync.model.CreateAgentRequest(
        activationKey,
        agentName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpointId.map(value => value),
        subnetArns.map(value => value),
        securityGroupArns.map(value => value)
      )
    def activationKey: ActivationKey
    def agentName: Optional[TagValue]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def vpcEndpointId: Optional[VpcEndpointId]
    def subnetArns: Optional[List[Ec2SubnetArn]]
    def securityGroupArns: Optional[List[Ec2SecurityGroupArn]]
    def getActivationKey: ZIO[Any, Nothing, ActivationKey] =
      ZIO.succeed(activationKey)
    def getAgentName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("agentName", agentName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getSubnetArns: ZIO[Any, AwsError, List[Ec2SubnetArn]] =
      AwsError.unwrapOptionField("subnetArns", subnetArns)
    def getSecurityGroupArns: ZIO[Any, AwsError, List[Ec2SecurityGroupArn]] =
      AwsError.unwrapOptionField("securityGroupArns", securityGroupArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateAgentRequest
  ) extends zio.aws.datasync.model.CreateAgentRequest.ReadOnly {
    override val activationKey: ActivationKey =
      zio.aws.datasync.model.primitives.ActivationKey(impl.activationKey())
    override val agentName: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.agentName())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
    override val vpcEndpointId: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => zio.aws.datasync.model.primitives.VpcEndpointId(value))
    override val subnetArns: Optional[List[Ec2SubnetArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.Ec2SubnetArn(item)
          }.toList
        )
    override val securityGroupArns: Optional[List[Ec2SecurityGroupArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateAgentRequest
  ): zio.aws.datasync.model.CreateAgentRequest.ReadOnly = new Wrapper(impl)
}
