package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTaskExecutionsResponse(
    taskExecutions: Optional[
      Iterable[zio.aws.datasync.model.TaskExecutionListEntry]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse = {
    import ListTaskExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse
      .builder()
      .optionallyWith(
        taskExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskExecutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListTaskExecutionsResponse.ReadOnly =
    zio.aws.datasync.model.ListTaskExecutionsResponse.wrap(buildAwsValue())
}
object ListTaskExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListTaskExecutionsResponse =
      zio.aws.datasync.model.ListTaskExecutionsResponse(
        taskExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def taskExecutions
        : Optional[List[zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTaskExecutions: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("taskExecutions", taskExecutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse
  ) extends zio.aws.datasync.model.ListTaskExecutionsResponse.ReadOnly {
    override val taskExecutions: Optional[
      List[zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.TaskExecutionListEntry.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse
  ): zio.aws.datasync.model.ListTaskExecutionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
