package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{Time, LocationUri, LocationArn}
import scala.jdk.CollectionConverters.*
final case class DescribeLocationNfsResponse(
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    onPremConfig: Optional[zio.aws.datasync.model.OnPremConfig] =
      Optional.Absent,
    mountOptions: Optional[zio.aws.datasync.model.NfsMountOptions] =
      Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse = {
    import DescribeLocationNfsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(onPremConfig.map(value => value.buildAwsValue()))(
        _.onPremConfig
      )
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationNfsResponse.wrap(buildAwsValue())
}
object DescribeLocationNfsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationNfsResponse =
      zio.aws.datasync.model.DescribeLocationNfsResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        onPremConfig.map(value => value.asEditable),
        mountOptions.map(value => value.asEditable),
        creationTime.map(value => value)
      )
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def onPremConfig: Optional[zio.aws.datasync.model.OnPremConfig.ReadOnly]
    def mountOptions: Optional[zio.aws.datasync.model.NfsMountOptions.ReadOnly]
    def creationTime: Optional[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getOnPremConfig
        : ZIO[Any, AwsError, zio.aws.datasync.model.OnPremConfig.ReadOnly] =
      AwsError.unwrapOptionField("onPremConfig", onPremConfig)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.NfsMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse
  ) extends zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val onPremConfig
        : Optional[zio.aws.datasync.model.OnPremConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onPremConfig())
        .map(value => zio.aws.datasync.model.OnPremConfig.wrap(value))
    override val mountOptions
        : Optional[zio.aws.datasync.model.NfsMountOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountOptions())
        .map(value => zio.aws.datasync.model.NfsMountOptions.wrap(value))
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationNfsResponse
  ): zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly = new Wrapper(
    impl
  )
}
