package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  FsxLustreSubdirectory,
  Ec2SecurityGroupArn,
  FsxFilesystemArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLocationFsxLustreRequest(
    fsxFilesystemArn: FsxFilesystemArn,
    securityGroupArns: Iterable[Ec2SecurityGroupArn],
    subdirectory: Optional[FsxLustreSubdirectory] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest = {
    import CreateLocationFsxLustreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest
      .builder()
      .fsxFilesystemArn(
        FsxFilesystemArn.unwrap(fsxFilesystemArn): java.lang.String
      )
      .securityGroupArns(securityGroupArns.map { item =>
        Ec2SecurityGroupArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        subdirectory.map(value =>
          FsxLustreSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationFsxLustreRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationFsxLustreRequest.wrap(buildAwsValue())
}
object CreateLocationFsxLustreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationFsxLustreRequest =
      zio.aws.datasync.model.CreateLocationFsxLustreRequest(
        fsxFilesystemArn,
        securityGroupArns,
        subdirectory.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fsxFilesystemArn: FsxFilesystemArn
    def securityGroupArns: List[Ec2SecurityGroupArn]
    def subdirectory: Optional[FsxLustreSubdirectory]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getFsxFilesystemArn: ZIO[Any, Nothing, FsxFilesystemArn] =
      ZIO.succeed(fsxFilesystemArn)
    def getSecurityGroupArns: ZIO[Any, Nothing, List[Ec2SecurityGroupArn]] =
      ZIO.succeed(securityGroupArns)
    def getSubdirectory: ZIO[Any, AwsError, FsxLustreSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest
  ) extends zio.aws.datasync.model.CreateLocationFsxLustreRequest.ReadOnly {
    override val fsxFilesystemArn: FsxFilesystemArn =
      zio.aws.datasync.model.primitives
        .FsxFilesystemArn(impl.fsxFilesystemArn())
    override val securityGroupArns: List[Ec2SecurityGroupArn] = impl
      .securityGroupArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
      }
      .toList
    override val subdirectory: Optional[FsxLustreSubdirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdirectory())
        .map(value =>
          zio.aws.datasync.model.primitives.FsxLustreSubdirectory(value)
        )
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest
  ): zio.aws.datasync.model.CreateLocationFsxLustreRequest.ReadOnly =
    new Wrapper(impl)
}
