package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  LocationArn,
  KerberosKeytabFile,
  KerberosPrincipal,
  KerberosKrb5ConfFile,
  HdfsReplicationFactor,
  HdfsUser,
  HdfsSubdirectory,
  KmsKeyProviderUri,
  AgentArn,
  HdfsBlockSize
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateLocationHdfsRequest(
    locationArn: LocationArn,
    subdirectory: Optional[HdfsSubdirectory] = Optional.Absent,
    nameNodes: Optional[Iterable[zio.aws.datasync.model.HdfsNameNode]] =
      Optional.Absent,
    blockSize: Optional[HdfsBlockSize] = Optional.Absent,
    replicationFactor: Optional[HdfsReplicationFactor] = Optional.Absent,
    kmsKeyProviderUri: Optional[KmsKeyProviderUri] = Optional.Absent,
    qopConfiguration: Optional[zio.aws.datasync.model.QopConfiguration] =
      Optional.Absent,
    authenticationType: Optional[
      zio.aws.datasync.model.HdfsAuthenticationType
    ] = Optional.Absent,
    simpleUser: Optional[HdfsUser] = Optional.Absent,
    kerberosPrincipal: Optional[KerberosPrincipal] = Optional.Absent,
    kerberosKeytab: Optional[KerberosKeytabFile] = Optional.Absent,
    kerberosKrb5Conf: Optional[KerberosKrb5ConfFile] = Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest = {
    import UpdateLocationHdfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        subdirectory.map(value =>
          HdfsSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        nameNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nameNodes)
      .optionallyWith(
        blockSize.map(value => HdfsBlockSize.unwrap(value): Integer)
      )(_.blockSize)
      .optionallyWith(
        replicationFactor.map(value =>
          HdfsReplicationFactor.unwrap(value): Integer
        )
      )(_.replicationFactor)
      .optionallyWith(
        kmsKeyProviderUri.map(value =>
          KmsKeyProviderUri.unwrap(value): java.lang.String
        )
      )(_.kmsKeyProviderUri)
      .optionallyWith(qopConfiguration.map(value => value.buildAwsValue()))(
        _.qopConfiguration
      )
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(
        simpleUser.map(value => HdfsUser.unwrap(value): java.lang.String)
      )(_.simpleUser)
      .optionallyWith(
        kerberosPrincipal.map(value =>
          KerberosPrincipal.unwrap(value): java.lang.String
        )
      )(_.kerberosPrincipal)
      .optionallyWith(
        kerberosKeytab.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.kerberosKeytab)
      .optionallyWith(
        kerberosKrb5Conf.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.kerberosKrb5Conf)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateLocationHdfsRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationHdfsRequest.wrap(buildAwsValue())
}
object UpdateLocationHdfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationHdfsRequest =
      zio.aws.datasync.model.UpdateLocationHdfsRequest(
        locationArn,
        subdirectory.map(value => value),
        nameNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blockSize.map(value => value),
        replicationFactor.map(value => value),
        kmsKeyProviderUri.map(value => value),
        qopConfiguration.map(value => value.asEditable),
        authenticationType.map(value => value),
        simpleUser.map(value => value),
        kerberosPrincipal.map(value => value),
        kerberosKeytab.map(value => value),
        kerberosKrb5Conf.map(value => value),
        agentArns.map(value => value)
      )
    def locationArn: LocationArn
    def subdirectory: Optional[HdfsSubdirectory]
    def nameNodes: Optional[List[zio.aws.datasync.model.HdfsNameNode.ReadOnly]]
    def blockSize: Optional[HdfsBlockSize]
    def replicationFactor: Optional[HdfsReplicationFactor]
    def kmsKeyProviderUri: Optional[KmsKeyProviderUri]
    def qopConfiguration
        : Optional[zio.aws.datasync.model.QopConfiguration.ReadOnly]
    def authenticationType
        : Optional[zio.aws.datasync.model.HdfsAuthenticationType]
    def simpleUser: Optional[HdfsUser]
    def kerberosPrincipal: Optional[KerberosPrincipal]
    def kerberosKeytab: Optional[KerberosKeytabFile]
    def kerberosKrb5Conf: Optional[KerberosKrb5ConfFile]
    def agentArns: Optional[List[AgentArn]]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getSubdirectory: ZIO[Any, AwsError, HdfsSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getNameNodes: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.HdfsNameNode.ReadOnly
    ]] = AwsError.unwrapOptionField("nameNodes", nameNodes)
    def getBlockSize: ZIO[Any, AwsError, HdfsBlockSize] =
      AwsError.unwrapOptionField("blockSize", blockSize)
    def getReplicationFactor: ZIO[Any, AwsError, HdfsReplicationFactor] =
      AwsError.unwrapOptionField("replicationFactor", replicationFactor)
    def getKmsKeyProviderUri: ZIO[Any, AwsError, KmsKeyProviderUri] =
      AwsError.unwrapOptionField("kmsKeyProviderUri", kmsKeyProviderUri)
    def getQopConfiguration
        : ZIO[Any, AwsError, zio.aws.datasync.model.QopConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("qopConfiguration", qopConfiguration)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.datasync.model.HdfsAuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getSimpleUser: ZIO[Any, AwsError, HdfsUser] =
      AwsError.unwrapOptionField("simpleUser", simpleUser)
    def getKerberosPrincipal: ZIO[Any, AwsError, KerberosPrincipal] =
      AwsError.unwrapOptionField("kerberosPrincipal", kerberosPrincipal)
    def getKerberosKeytab: ZIO[Any, AwsError, KerberosKeytabFile] =
      AwsError.unwrapOptionField("kerberosKeytab", kerberosKeytab)
    def getKerberosKrb5Conf: ZIO[Any, AwsError, KerberosKrb5ConfFile] =
      AwsError.unwrapOptionField("kerberosKrb5Conf", kerberosKrb5Conf)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest
  ) extends zio.aws.datasync.model.UpdateLocationHdfsRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val subdirectory: Optional[HdfsSubdirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdirectory())
        .map(value => zio.aws.datasync.model.primitives.HdfsSubdirectory(value))
    override val nameNodes
        : Optional[List[zio.aws.datasync.model.HdfsNameNode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameNodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.HdfsNameNode.wrap(item)
          }.toList
        )
    override val blockSize: Optional[HdfsBlockSize] = zio.aws.core.internal
      .optionalFromNullable(impl.blockSize())
      .map(value => zio.aws.datasync.model.primitives.HdfsBlockSize(value))
    override val replicationFactor: Optional[HdfsReplicationFactor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationFactor())
        .map(value =>
          zio.aws.datasync.model.primitives.HdfsReplicationFactor(value)
        )
    override val kmsKeyProviderUri: Optional[KmsKeyProviderUri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyProviderUri())
        .map(value =>
          zio.aws.datasync.model.primitives.KmsKeyProviderUri(value)
        )
    override val qopConfiguration
        : Optional[zio.aws.datasync.model.QopConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qopConfiguration())
        .map(value => zio.aws.datasync.model.QopConfiguration.wrap(value))
    override val authenticationType
        : Optional[zio.aws.datasync.model.HdfsAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value => zio.aws.datasync.model.HdfsAuthenticationType.wrap(value))
    override val simpleUser: Optional[HdfsUser] = zio.aws.core.internal
      .optionalFromNullable(impl.simpleUser())
      .map(value => zio.aws.datasync.model.primitives.HdfsUser(value))
    override val kerberosPrincipal: Optional[KerberosPrincipal] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosPrincipal())
        .map(value =>
          zio.aws.datasync.model.primitives.KerberosPrincipal(value)
        )
    override val kerberosKeytab: Optional[KerberosKeytabFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosKeytab())
        .map(value =>
          zio.aws.datasync.model.primitives
            .KerberosKeytabFile(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val kerberosKrb5Conf: Optional[KerberosKrb5ConfFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosKrb5Conf())
        .map(value =>
          zio.aws.datasync.model.primitives.KerberosKrb5ConfFile(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest
  ): zio.aws.datasync.model.UpdateLocationHdfsRequest.ReadOnly = new Wrapper(
    impl
  )
}
