package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait Uid {
  def unwrap: software.amazon.awssdk.services.datasync.model.Uid
}
object Uid {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.Uid
  ): zio.aws.datasync.model.Uid = value match {
    case software.amazon.awssdk.services.datasync.model.Uid.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.Uid.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.datasync.model.Uid.INT_VALUE =>
      val r = INT_VALUE
      r
    case software.amazon.awssdk.services.datasync.model.Uid.NAME =>
      val r = NAME
      r
    case software.amazon.awssdk.services.datasync.model.Uid.BOTH =>
      val r = BOTH
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.Uid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Uid =
      software.amazon.awssdk.services.datasync.model.Uid.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.datasync.model.Uid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Uid =
      software.amazon.awssdk.services.datasync.model.Uid.NONE
  }
  case object INT_VALUE extends zio.aws.datasync.model.Uid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Uid =
      software.amazon.awssdk.services.datasync.model.Uid.INT_VALUE
  }
  case object NAME extends zio.aws.datasync.model.Uid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Uid =
      software.amazon.awssdk.services.datasync.model.Uid.NAME
  }
  case object BOTH extends zio.aws.datasync.model.Uid {
    override def unwrap: software.amazon.awssdk.services.datasync.model.Uid =
      software.amazon.awssdk.services.datasync.model.Uid.BOTH
  }
}
