package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeLocationObjectStorageRequest(
    locationArn: LocationArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest = {
    import DescribeLocationObjectStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationObjectStorageRequest.ReadOnly =
    zio.aws.datasync.model.DescribeLocationObjectStorageRequest
      .wrap(buildAwsValue())
}
object DescribeLocationObjectStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datasync.model.DescribeLocationObjectStorageRequest =
      zio.aws.datasync.model.DescribeLocationObjectStorageRequest(locationArn)
    def locationArn: LocationArn
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest
  ) extends zio.aws.datasync.model.DescribeLocationObjectStorageRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest
  ): zio.aws.datasync.model.DescribeLocationObjectStorageRequest.ReadOnly =
    new Wrapper(impl)
}
