package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  KerberosKeytabFile,
  KerberosPrincipal,
  KerberosKrb5ConfFile,
  HdfsReplicationFactor,
  HdfsUser,
  HdfsSubdirectory,
  KmsKeyProviderUri,
  AgentArn,
  HdfsBlockSize
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateLocationHdfsRequest(
    subdirectory: Optional[HdfsSubdirectory] = Optional.Absent,
    nameNodes: Iterable[zio.aws.datasync.model.HdfsNameNode],
    blockSize: Optional[HdfsBlockSize] = Optional.Absent,
    replicationFactor: Optional[HdfsReplicationFactor] = Optional.Absent,
    kmsKeyProviderUri: Optional[KmsKeyProviderUri] = Optional.Absent,
    qopConfiguration: Optional[zio.aws.datasync.model.QopConfiguration] =
      Optional.Absent,
    authenticationType: zio.aws.datasync.model.HdfsAuthenticationType,
    simpleUser: Optional[HdfsUser] = Optional.Absent,
    kerberosPrincipal: Optional[KerberosPrincipal] = Optional.Absent,
    kerberosKeytab: Optional[KerberosKeytabFile] = Optional.Absent,
    kerberosKrb5Conf: Optional[KerberosKrb5ConfFile] = Optional.Absent,
    agentArns: Iterable[AgentArn],
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest = {
    import CreateLocationHdfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest
      .builder()
      .optionallyWith(
        subdirectory.map(value =>
          HdfsSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .nameNodes(nameNodes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        blockSize.map(value => HdfsBlockSize.unwrap(value): Integer)
      )(_.blockSize)
      .optionallyWith(
        replicationFactor.map(value =>
          HdfsReplicationFactor.unwrap(value): Integer
        )
      )(_.replicationFactor)
      .optionallyWith(
        kmsKeyProviderUri.map(value =>
          KmsKeyProviderUri.unwrap(value): java.lang.String
        )
      )(_.kmsKeyProviderUri)
      .optionallyWith(qopConfiguration.map(value => value.buildAwsValue()))(
        _.qopConfiguration
      )
      .authenticationType(authenticationType.unwrap)
      .optionallyWith(
        simpleUser.map(value => HdfsUser.unwrap(value): java.lang.String)
      )(_.simpleUser)
      .optionallyWith(
        kerberosPrincipal.map(value =>
          KerberosPrincipal.unwrap(value): java.lang.String
        )
      )(_.kerberosPrincipal)
      .optionallyWith(
        kerberosKeytab.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.kerberosKeytab)
      .optionallyWith(
        kerberosKrb5Conf.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.kerberosKrb5Conf)
      .agentArns(agentArns.map { item =>
        AgentArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateLocationHdfsRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationHdfsRequest.wrap(buildAwsValue())
}
object CreateLocationHdfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationHdfsRequest =
      zio.aws.datasync.model.CreateLocationHdfsRequest(
        subdirectory.map(value => value),
        nameNodes.map { item =>
          item.asEditable
        },
        blockSize.map(value => value),
        replicationFactor.map(value => value),
        kmsKeyProviderUri.map(value => value),
        qopConfiguration.map(value => value.asEditable),
        authenticationType,
        simpleUser.map(value => value),
        kerberosPrincipal.map(value => value),
        kerberosKeytab.map(value => value),
        kerberosKrb5Conf.map(value => value),
        agentArns,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subdirectory: Optional[HdfsSubdirectory]
    def nameNodes: List[zio.aws.datasync.model.HdfsNameNode.ReadOnly]
    def blockSize: Optional[HdfsBlockSize]
    def replicationFactor: Optional[HdfsReplicationFactor]
    def kmsKeyProviderUri: Optional[KmsKeyProviderUri]
    def qopConfiguration
        : Optional[zio.aws.datasync.model.QopConfiguration.ReadOnly]
    def authenticationType: zio.aws.datasync.model.HdfsAuthenticationType
    def simpleUser: Optional[HdfsUser]
    def kerberosPrincipal: Optional[KerberosPrincipal]
    def kerberosKeytab: Optional[KerberosKeytabFile]
    def kerberosKrb5Conf: Optional[KerberosKrb5ConfFile]
    def agentArns: List[AgentArn]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getSubdirectory: ZIO[Any, AwsError, HdfsSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getNameNodes: ZIO[Any, Nothing, List[
      zio.aws.datasync.model.HdfsNameNode.ReadOnly
    ]] = ZIO.succeed(nameNodes)
    def getBlockSize: ZIO[Any, AwsError, HdfsBlockSize] =
      AwsError.unwrapOptionField("blockSize", blockSize)
    def getReplicationFactor: ZIO[Any, AwsError, HdfsReplicationFactor] =
      AwsError.unwrapOptionField("replicationFactor", replicationFactor)
    def getKmsKeyProviderUri: ZIO[Any, AwsError, KmsKeyProviderUri] =
      AwsError.unwrapOptionField("kmsKeyProviderUri", kmsKeyProviderUri)
    def getQopConfiguration
        : ZIO[Any, AwsError, zio.aws.datasync.model.QopConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("qopConfiguration", qopConfiguration)
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.datasync.model.HdfsAuthenticationType] =
      ZIO.succeed(authenticationType)
    def getSimpleUser: ZIO[Any, AwsError, HdfsUser] =
      AwsError.unwrapOptionField("simpleUser", simpleUser)
    def getKerberosPrincipal: ZIO[Any, AwsError, KerberosPrincipal] =
      AwsError.unwrapOptionField("kerberosPrincipal", kerberosPrincipal)
    def getKerberosKeytab: ZIO[Any, AwsError, KerberosKeytabFile] =
      AwsError.unwrapOptionField("kerberosKeytab", kerberosKeytab)
    def getKerberosKrb5Conf: ZIO[Any, AwsError, KerberosKrb5ConfFile] =
      AwsError.unwrapOptionField("kerberosKrb5Conf", kerberosKrb5Conf)
    def getAgentArns: ZIO[Any, Nothing, List[AgentArn]] = ZIO.succeed(agentArns)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest
  ) extends zio.aws.datasync.model.CreateLocationHdfsRequest.ReadOnly {
    override val subdirectory: Optional[HdfsSubdirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdirectory())
        .map(value => zio.aws.datasync.model.primitives.HdfsSubdirectory(value))
    override val nameNodes: List[zio.aws.datasync.model.HdfsNameNode.ReadOnly] =
      impl
        .nameNodes()
        .asScala
        .map { item =>
          zio.aws.datasync.model.HdfsNameNode.wrap(item)
        }
        .toList
    override val blockSize: Optional[HdfsBlockSize] = zio.aws.core.internal
      .optionalFromNullable(impl.blockSize())
      .map(value => zio.aws.datasync.model.primitives.HdfsBlockSize(value))
    override val replicationFactor: Optional[HdfsReplicationFactor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationFactor())
        .map(value =>
          zio.aws.datasync.model.primitives.HdfsReplicationFactor(value)
        )
    override val kmsKeyProviderUri: Optional[KmsKeyProviderUri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyProviderUri())
        .map(value =>
          zio.aws.datasync.model.primitives.KmsKeyProviderUri(value)
        )
    override val qopConfiguration
        : Optional[zio.aws.datasync.model.QopConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qopConfiguration())
        .map(value => zio.aws.datasync.model.QopConfiguration.wrap(value))
    override val authenticationType
        : zio.aws.datasync.model.HdfsAuthenticationType =
      zio.aws.datasync.model.HdfsAuthenticationType
        .wrap(impl.authenticationType())
    override val simpleUser: Optional[HdfsUser] = zio.aws.core.internal
      .optionalFromNullable(impl.simpleUser())
      .map(value => zio.aws.datasync.model.primitives.HdfsUser(value))
    override val kerberosPrincipal: Optional[KerberosPrincipal] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosPrincipal())
        .map(value =>
          zio.aws.datasync.model.primitives.KerberosPrincipal(value)
        )
    override val kerberosKeytab: Optional[KerberosKeytabFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosKeytab())
        .map(value =>
          zio.aws.datasync.model.primitives
            .KerberosKeytabFile(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val kerberosKrb5Conf: Optional[KerberosKrb5ConfFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosKrb5Conf())
        .map(value =>
          zio.aws.datasync.model.primitives.KerberosKrb5ConfFile(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
    override val agentArns: List[AgentArn] = impl
      .agentArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.AgentArn(item)
      }
      .toList
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest
  ): zio.aws.datasync.model.CreateLocationHdfsRequest.ReadOnly = new Wrapper(
    impl
  )
}
