package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Time,
  ObjectStorageServerPort,
  ObjectStorageAccessKey,
  LocationArn,
  LocationUri,
  AgentArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeLocationObjectStorageResponse(
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    accessKey: Optional[ObjectStorageAccessKey] = Optional.Absent,
    serverPort: Optional[ObjectStorageServerPort] = Optional.Absent,
    serverProtocol: Optional[
      zio.aws.datasync.model.ObjectStorageServerProtocol
    ] = Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse = {
    import DescribeLocationObjectStorageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        accessKey.map(value =>
          ObjectStorageAccessKey.unwrap(value): java.lang.String
        )
      )(_.accessKey)
      .optionallyWith(
        serverPort.map(value => ObjectStorageServerPort.unwrap(value): Integer)
      )(_.serverPort)
      .optionallyWith(serverProtocol.map(value => value.unwrap))(
        _.serverProtocol
      )
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationObjectStorageResponse
      .wrap(buildAwsValue())
}
object DescribeLocationObjectStorageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datasync.model.DescribeLocationObjectStorageResponse =
      zio.aws.datasync.model.DescribeLocationObjectStorageResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        accessKey.map(value => value),
        serverPort.map(value => value),
        serverProtocol.map(value => value),
        agentArns.map(value => value),
        creationTime.map(value => value)
      )
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def accessKey: Optional[ObjectStorageAccessKey]
    def serverPort: Optional[ObjectStorageServerPort]
    def serverProtocol
        : Optional[zio.aws.datasync.model.ObjectStorageServerProtocol]
    def agentArns: Optional[List[AgentArn]]
    def creationTime: Optional[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getAccessKey: ZIO[Any, AwsError, ObjectStorageAccessKey] =
      AwsError.unwrapOptionField("accessKey", accessKey)
    def getServerPort: ZIO[Any, AwsError, ObjectStorageServerPort] =
      AwsError.unwrapOptionField("serverPort", serverPort)
    def getServerProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.ObjectStorageServerProtocol
    ] = AwsError.unwrapOptionField("serverProtocol", serverProtocol)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse
  ) extends zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val accessKey: Optional[ObjectStorageAccessKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessKey())
        .map(value =>
          zio.aws.datasync.model.primitives.ObjectStorageAccessKey(value)
        )
    override val serverPort: Optional[ObjectStorageServerPort] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverPort())
        .map(value =>
          zio.aws.datasync.model.primitives.ObjectStorageServerPort(value)
        )
    override val serverProtocol
        : Optional[zio.aws.datasync.model.ObjectStorageServerProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverProtocol())
        .map(value =>
          zio.aws.datasync.model.ObjectStorageServerProtocol.wrap(value)
        )
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse
  ): zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly =
    new Wrapper(impl)
}
