package zio.aws.datasync.model
import java.lang.Integer
import zio.aws.datasync.model.primitives.{
  ObjectStorageServerPort,
  ObjectStorageAccessKey,
  ObjectStorageSecretKey,
  ObjectStorageBucketName,
  S3Subdirectory,
  ServerHostname,
  AgentArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLocationObjectStorageRequest(
    serverHostname: ServerHostname,
    serverPort: Option[ObjectStorageServerPort] = None,
    serverProtocol: Option[zio.aws.datasync.model.ObjectStorageServerProtocol] =
      None,
    subdirectory: Option[S3Subdirectory] = None,
    bucketName: ObjectStorageBucketName,
    accessKey: Option[ObjectStorageAccessKey] = None,
    secretKey: Option[ObjectStorageSecretKey] = None,
    agentArns: Iterable[AgentArn],
    tags: Option[Iterable[zio.aws.datasync.model.TagListEntry]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest = {
    import CreateLocationObjectStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest
      .builder()
      .serverHostname(ServerHostname.unwrap(serverHostname): java.lang.String)
      .optionallyWith(
        serverPort.map(value => ObjectStorageServerPort.unwrap(value): Integer)
      )(_.serverPort)
      .optionallyWith(serverProtocol.map(value => value.unwrap))(
        _.serverProtocol
      )
      .optionallyWith(
        subdirectory.map(value =>
          S3Subdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .bucketName(ObjectStorageBucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        accessKey.map(value =>
          ObjectStorageAccessKey.unwrap(value): java.lang.String
        )
      )(_.accessKey)
      .optionallyWith(
        secretKey.map(value =>
          ObjectStorageSecretKey.unwrap(value): java.lang.String
        )
      )(_.secretKey)
      .agentArns(agentArns.map { item =>
        AgentArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationObjectStorageRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationObjectStorageRequest
      .wrap(buildAwsValue())
}
object CreateLocationObjectStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationObjectStorageRequest =
      zio.aws.datasync.model.CreateLocationObjectStorageRequest(
        serverHostname,
        serverPort.map(value => value),
        serverProtocol.map(value => value),
        subdirectory.map(value => value),
        bucketName,
        accessKey.map(value => value),
        secretKey.map(value => value),
        agentArns,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverHostname: ServerHostname
    def serverPort: Option[ObjectStorageServerPort]
    def serverProtocol
        : Option[zio.aws.datasync.model.ObjectStorageServerProtocol]
    def subdirectory: Option[S3Subdirectory]
    def bucketName: ObjectStorageBucketName
    def accessKey: Option[ObjectStorageAccessKey]
    def secretKey: Option[ObjectStorageSecretKey]
    def agentArns: List[AgentArn]
    def tags: Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getServerHostname: ZIO[Any, Nothing, ServerHostname] =
      ZIO.succeed(serverHostname)
    def getServerPort: ZIO[Any, AwsError, ObjectStorageServerPort] =
      AwsError.unwrapOptionField("serverPort", serverPort)
    def getServerProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.ObjectStorageServerProtocol
    ] = AwsError.unwrapOptionField("serverProtocol", serverProtocol)
    def getSubdirectory: ZIO[Any, AwsError, S3Subdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getBucketName: ZIO[Any, Nothing, ObjectStorageBucketName] =
      ZIO.succeed(bucketName)
    def getAccessKey: ZIO[Any, AwsError, ObjectStorageAccessKey] =
      AwsError.unwrapOptionField("accessKey", accessKey)
    def getSecretKey: ZIO[Any, AwsError, ObjectStorageSecretKey] =
      AwsError.unwrapOptionField("secretKey", secretKey)
    def getAgentArns: ZIO[Any, Nothing, List[AgentArn]] = ZIO.succeed(agentArns)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest
  ) extends zio.aws.datasync.model.CreateLocationObjectStorageRequest.ReadOnly {
    override val serverHostname: ServerHostname =
      zio.aws.datasync.model.primitives.ServerHostname(impl.serverHostname())
    override val serverPort: Option[ObjectStorageServerPort] = scala
      .Option(impl.serverPort())
      .map(value =>
        zio.aws.datasync.model.primitives.ObjectStorageServerPort(value)
      )
    override val serverProtocol
        : Option[zio.aws.datasync.model.ObjectStorageServerProtocol] = scala
      .Option(impl.serverProtocol())
      .map(value =>
        zio.aws.datasync.model.ObjectStorageServerProtocol.wrap(value)
      )
    override val subdirectory: Option[S3Subdirectory] = scala
      .Option(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.S3Subdirectory(value))
    override val bucketName: ObjectStorageBucketName =
      zio.aws.datasync.model.primitives
        .ObjectStorageBucketName(impl.bucketName())
    override val accessKey: Option[ObjectStorageAccessKey] = scala
      .Option(impl.accessKey())
      .map(value =>
        zio.aws.datasync.model.primitives.ObjectStorageAccessKey(value)
      )
    override val secretKey: Option[ObjectStorageSecretKey] = scala
      .Option(impl.secretKey())
      .map(value =>
        zio.aws.datasync.model.primitives.ObjectStorageSecretKey(value)
      )
    override val agentArns: List[AgentArn] = impl
      .agentArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.AgentArn(item)
      }
      .toList
    override val tags
        : Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.TagListEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest
  ): zio.aws.datasync.model.CreateLocationObjectStorageRequest.ReadOnly =
    new Wrapper(impl)
}
