package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskExecutionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartTaskExecutionResponse(
    taskExecutionArn: Option[TaskExecutionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse = {
    import StartTaskExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse
      .builder()
      .optionallyWith(
        taskExecutionArn.map(value =>
          TaskExecutionArn.unwrap(value): java.lang.String
        )
      )(_.taskExecutionArn)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly =
    zio.aws.datasync.model.StartTaskExecutionResponse.wrap(buildAwsValue())
}
object StartTaskExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.StartTaskExecutionResponse =
      zio.aws.datasync.model
        .StartTaskExecutionResponse(taskExecutionArn.map(value => value))
    def taskExecutionArn: Option[TaskExecutionArn]
    def getTaskExecutionArn: ZIO[Any, AwsError, TaskExecutionArn] =
      AwsError.unwrapOptionField("taskExecutionArn", taskExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse
  ) extends zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly {
    override val taskExecutionArn: Option[TaskExecutionArn] = scala
      .Option(impl.taskExecutionArn())
      .map(value => zio.aws.datasync.model.primitives.TaskExecutionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse
  ): zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
