package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{LogGroupArn, TagValue, TaskArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateTaskRequest(
    taskArn: TaskArn,
    options: Option[zio.aws.datasync.model.Options] = None,
    excludes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None,
    schedule: Option[zio.aws.datasync.model.TaskSchedule] = None,
    name: Option[TagValue] = None,
    cloudWatchLogGroupArn: Option[LogGroupArn] = None,
    includes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateTaskRequest = {
    import UpdateTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateTaskRequest
      .builder()
      .taskArn(TaskArn.unwrap(taskArn): java.lang.String)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          LogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateTaskRequest.ReadOnly =
    zio.aws.datasync.model.UpdateTaskRequest.wrap(buildAwsValue())
}
object UpdateTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateTaskRequest =
      zio.aws.datasync.model.UpdateTaskRequest(
        taskArn,
        options.map(value => value.asEditable),
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schedule.map(value => value.asEditable),
        name.map(value => value),
        cloudWatchLogGroupArn.map(value => value),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskArn: TaskArn
    def options: Option[zio.aws.datasync.model.Options.ReadOnly]
    def excludes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def schedule: Option[zio.aws.datasync.model.TaskSchedule.ReadOnly]
    def name: Option[TagValue]
    def cloudWatchLogGroupArn: Option[LogGroupArn]
    def includes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def getTaskArn: ZIO[Any, Nothing, TaskArn] = ZIO.succeed(taskArn)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.Options.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getExcludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludes", excludes)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskSchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getIncludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateTaskRequest
  ) extends zio.aws.datasync.model.UpdateTaskRequest.ReadOnly {
    override val taskArn: TaskArn =
      zio.aws.datasync.model.primitives.TaskArn(impl.taskArn())
    override val options: Option[zio.aws.datasync.model.Options.ReadOnly] =
      scala
        .Option(impl.options())
        .map(value => zio.aws.datasync.model.Options.wrap(value))
    override val excludes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.excludes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
    override val schedule
        : Option[zio.aws.datasync.model.TaskSchedule.ReadOnly] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.datasync.model.TaskSchedule.wrap(value))
    override val name: Option[TagValue] = scala
      .Option(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val cloudWatchLogGroupArn: Option[LogGroupArn] = scala
      .Option(impl.cloudWatchLogGroupArn())
      .map(value => zio.aws.datasync.model.primitives.LogGroupArn(value))
    override val includes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.includes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateTaskRequest
  ): zio.aws.datasync.model.UpdateTaskRequest.ReadOnly = new Wrapper(impl)
}
