package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{TagValue, LogGroupArn, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTaskRequest(
    sourceLocationArn: LocationArn,
    destinationLocationArn: LocationArn,
    cloudWatchLogGroupArn: Option[LogGroupArn] = None,
    name: Option[TagValue] = None,
    options: Option[zio.aws.datasync.model.Options] = None,
    excludes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None,
    schedule: Option[zio.aws.datasync.model.TaskSchedule] = None,
    tags: Option[Iterable[zio.aws.datasync.model.TagListEntry]] = None,
    includes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateTaskRequest = {
    import CreateTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateTaskRequest
      .builder()
      .sourceLocationArn(
        LocationArn.unwrap(sourceLocationArn): java.lang.String
      )
      .destinationLocationArn(
        LocationArn.unwrap(destinationLocationArn): java.lang.String
      )
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          LogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateTaskRequest.ReadOnly =
    zio.aws.datasync.model.CreateTaskRequest.wrap(buildAwsValue())
}
object CreateTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateTaskRequest =
      zio.aws.datasync.model.CreateTaskRequest(
        sourceLocationArn,
        destinationLocationArn,
        cloudWatchLogGroupArn.map(value => value),
        name.map(value => value),
        options.map(value => value.asEditable),
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schedule.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceLocationArn: LocationArn
    def destinationLocationArn: LocationArn
    def cloudWatchLogGroupArn: Option[LogGroupArn]
    def name: Option[TagValue]
    def options: Option[zio.aws.datasync.model.Options.ReadOnly]
    def excludes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def schedule: Option[zio.aws.datasync.model.TaskSchedule.ReadOnly]
    def tags: Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def includes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def getSourceLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(sourceLocationArn)
    def getDestinationLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(destinationLocationArn)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.Options.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getExcludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludes", excludes)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskSchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getIncludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateTaskRequest
  ) extends zio.aws.datasync.model.CreateTaskRequest.ReadOnly {
    override val sourceLocationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.sourceLocationArn())
    override val destinationLocationArn: LocationArn =
      zio.aws.datasync.model.primitives
        .LocationArn(impl.destinationLocationArn())
    override val cloudWatchLogGroupArn: Option[LogGroupArn] = scala
      .Option(impl.cloudWatchLogGroupArn())
      .map(value => zio.aws.datasync.model.primitives.LogGroupArn(value))
    override val name: Option[TagValue] = scala
      .Option(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val options: Option[zio.aws.datasync.model.Options.ReadOnly] =
      scala
        .Option(impl.options())
        .map(value => zio.aws.datasync.model.Options.wrap(value))
    override val excludes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.excludes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
    override val schedule
        : Option[zio.aws.datasync.model.TaskSchedule.ReadOnly] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.datasync.model.TaskSchedule.wrap(value))
    override val tags
        : Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.TagListEntry.wrap(item)
        }.toList
      )
    override val includes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.includes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateTaskRequest
  ): zio.aws.datasync.model.CreateTaskRequest.ReadOnly = new Wrapper(impl)
}
