package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{TagValue, AgentArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AgentListEntry(
    agentArn: Option[AgentArn] = None,
    name: Option[TagValue] = None,
    status: Option[zio.aws.datasync.model.AgentStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.AgentListEntry = {
    import AgentListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.AgentListEntry
      .builder()
      .optionallyWith(
        agentArn.map(value => AgentArn.unwrap(value): java.lang.String)
      )(_.agentArn)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.AgentListEntry.ReadOnly =
    zio.aws.datasync.model.AgentListEntry.wrap(buildAwsValue())
}
object AgentListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.AgentListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.AgentListEntry =
      zio.aws.datasync.model.AgentListEntry(
        agentArn.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def agentArn: Option[AgentArn]
    def name: Option[TagValue]
    def status: Option[zio.aws.datasync.model.AgentStatus]
    def getAgentArn: ZIO[Any, AwsError, AgentArn] =
      AwsError.unwrapOptionField("agentArn", agentArn)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.AgentStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.AgentListEntry
  ) extends zio.aws.datasync.model.AgentListEntry.ReadOnly {
    override val agentArn: Option[AgentArn] = scala
      .Option(impl.agentArn())
      .map(value => zio.aws.datasync.model.primitives.AgentArn(value))
    override val name: Option[TagValue] = scala
      .Option(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val status: Option[zio.aws.datasync.model.AgentStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.datasync.model.AgentStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.AgentListEntry
  ): zio.aws.datasync.model.AgentListEntry.ReadOnly = new Wrapper(impl)
}
