package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.Duration
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TaskExecutionResultDetail(
    prepareDuration: Option[Duration] = None,
    prepareStatus: Option[zio.aws.datasync.model.PhaseStatus] = None,
    totalDuration: Option[Duration] = None,
    transferDuration: Option[Duration] = None,
    transferStatus: Option[zio.aws.datasync.model.PhaseStatus] = None,
    verifyDuration: Option[Duration] = None,
    verifyStatus: Option[zio.aws.datasync.model.PhaseStatus] = None,
    errorCode: Option[String] = None,
    errorDetail: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskExecutionResultDetail = {
    import TaskExecutionResultDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskExecutionResultDetail
      .builder()
      .optionallyWith(
        prepareDuration.map(value => Duration.unwrap(value): java.lang.Long)
      )(_.prepareDuration)
      .optionallyWith(prepareStatus.map(value => value.unwrap))(_.prepareStatus)
      .optionallyWith(
        totalDuration.map(value => Duration.unwrap(value): java.lang.Long)
      )(_.totalDuration)
      .optionallyWith(
        transferDuration.map(value => Duration.unwrap(value): java.lang.Long)
      )(_.transferDuration)
      .optionallyWith(transferStatus.map(value => value.unwrap))(
        _.transferStatus
      )
      .optionallyWith(
        verifyDuration.map(value => Duration.unwrap(value): java.lang.Long)
      )(_.verifyDuration)
      .optionallyWith(verifyStatus.map(value => value.unwrap))(_.verifyStatus)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorDetail.map(value => value: java.lang.String))(
        _.errorDetail
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskExecutionResultDetail.ReadOnly =
    zio.aws.datasync.model.TaskExecutionResultDetail.wrap(buildAwsValue())
}
object TaskExecutionResultDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskExecutionResultDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskExecutionResultDetail =
      zio.aws.datasync.model.TaskExecutionResultDetail(
        prepareDuration.map(value => value),
        prepareStatus.map(value => value),
        totalDuration.map(value => value),
        transferDuration.map(value => value),
        transferStatus.map(value => value),
        verifyDuration.map(value => value),
        verifyStatus.map(value => value),
        errorCode.map(value => value),
        errorDetail.map(value => value)
      )
    def prepareDuration: Option[Duration]
    def prepareStatus: Option[zio.aws.datasync.model.PhaseStatus]
    def totalDuration: Option[Duration]
    def transferDuration: Option[Duration]
    def transferStatus: Option[zio.aws.datasync.model.PhaseStatus]
    def verifyDuration: Option[Duration]
    def verifyStatus: Option[zio.aws.datasync.model.PhaseStatus]
    def errorCode: Option[String]
    def errorDetail: Option[String]
    def getPrepareDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("prepareDuration", prepareDuration)
    def getPrepareStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.PhaseStatus] =
      AwsError.unwrapOptionField("prepareStatus", prepareStatus)
    def getTotalDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("totalDuration", totalDuration)
    def getTransferDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("transferDuration", transferDuration)
    def getTransferStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.PhaseStatus] =
      AwsError.unwrapOptionField("transferStatus", transferStatus)
    def getVerifyDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("verifyDuration", verifyDuration)
    def getVerifyStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.PhaseStatus] =
      AwsError.unwrapOptionField("verifyStatus", verifyStatus)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorDetail", errorDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionResultDetail
  ) extends zio.aws.datasync.model.TaskExecutionResultDetail.ReadOnly {
    override val prepareDuration: Option[Duration] = scala
      .Option(impl.prepareDuration())
      .map(value => zio.aws.datasync.model.primitives.Duration(value))
    override val prepareStatus: Option[zio.aws.datasync.model.PhaseStatus] =
      scala
        .Option(impl.prepareStatus())
        .map(value => zio.aws.datasync.model.PhaseStatus.wrap(value))
    override val totalDuration: Option[Duration] = scala
      .Option(impl.totalDuration())
      .map(value => zio.aws.datasync.model.primitives.Duration(value))
    override val transferDuration: Option[Duration] = scala
      .Option(impl.transferDuration())
      .map(value => zio.aws.datasync.model.primitives.Duration(value))
    override val transferStatus: Option[zio.aws.datasync.model.PhaseStatus] =
      scala
        .Option(impl.transferStatus())
        .map(value => zio.aws.datasync.model.PhaseStatus.wrap(value))
    override val verifyDuration: Option[Duration] = scala
      .Option(impl.verifyDuration())
      .map(value => zio.aws.datasync.model.primitives.Duration(value))
    override val verifyStatus: Option[zio.aws.datasync.model.PhaseStatus] =
      scala
        .Option(impl.verifyStatus())
        .map(value => zio.aws.datasync.model.PhaseStatus.wrap(value))
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val errorDetail: Option[String] =
      scala.Option(impl.errorDetail()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionResultDetail
  ): zio.aws.datasync.model.TaskExecutionResultDetail.ReadOnly = new Wrapper(
    impl
  )
}
