package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TagListEntry(key: TagKey, value: Option[TagValue] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TagListEntry = {
    import TagListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TagListEntry
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TagListEntry.ReadOnly =
    zio.aws.datasync.model.TagListEntry.wrap(buildAwsValue())
}
object TagListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TagListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TagListEntry =
      zio.aws.datasync.model.TagListEntry(key, value.map(value => value))
    def key: TagKey
    def value: Option[TagValue]
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TagListEntry
  ) extends zio.aws.datasync.model.TagListEntry.ReadOnly {
    override val key: TagKey =
      zio.aws.datasync.model.primitives.TagKey(impl.key())
    override val value: Option[TagValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TagListEntry
  ): zio.aws.datasync.model.TagListEntry.ReadOnly = new Wrapper(impl)
}
