package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{Time, TagValue, AgentArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeAgentResponse(
    agentArn: Option[AgentArn] = None,
    name: Option[TagValue] = None,
    status: Option[zio.aws.datasync.model.AgentStatus] = None,
    lastConnectionTime: Option[Time] = None,
    creationTime: Option[Time] = None,
    endpointType: Option[zio.aws.datasync.model.EndpointType] = None,
    privateLinkConfig: Option[zio.aws.datasync.model.PrivateLinkConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeAgentResponse = {
    import DescribeAgentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeAgentResponse
      .builder()
      .optionallyWith(
        agentArn.map(value => AgentArn.unwrap(value): java.lang.String)
      )(_.agentArn)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastConnectionTime.map(value => Time.unwrap(value): Instant)
      )(_.lastConnectionTime)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(privateLinkConfig.map(value => value.buildAwsValue()))(
        _.privateLinkConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeAgentResponse.ReadOnly =
    zio.aws.datasync.model.DescribeAgentResponse.wrap(buildAwsValue())
}
object DescribeAgentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeAgentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeAgentResponse =
      zio.aws.datasync.model.DescribeAgentResponse(
        agentArn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        lastConnectionTime.map(value => value),
        creationTime.map(value => value),
        endpointType.map(value => value),
        privateLinkConfig.map(value => value.asEditable)
      )
    def agentArn: Option[AgentArn]
    def name: Option[TagValue]
    def status: Option[zio.aws.datasync.model.AgentStatus]
    def lastConnectionTime: Option[Time]
    def creationTime: Option[Time]
    def endpointType: Option[zio.aws.datasync.model.EndpointType]
    def privateLinkConfig
        : Option[zio.aws.datasync.model.PrivateLinkConfig.ReadOnly]
    def getAgentArn: ZIO[Any, AwsError, AgentArn] =
      AwsError.unwrapOptionField("agentArn", agentArn)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.AgentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastConnectionTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("lastConnectionTime", lastConnectionTime)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.datasync.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getPrivateLinkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.PrivateLinkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("privateLinkConfig", privateLinkConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeAgentResponse
  ) extends zio.aws.datasync.model.DescribeAgentResponse.ReadOnly {
    override val agentArn: Option[AgentArn] = scala
      .Option(impl.agentArn())
      .map(value => zio.aws.datasync.model.primitives.AgentArn(value))
    override val name: Option[TagValue] = scala
      .Option(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val status: Option[zio.aws.datasync.model.AgentStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.datasync.model.AgentStatus.wrap(value))
    override val lastConnectionTime: Option[Time] = scala
      .Option(impl.lastConnectionTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val endpointType: Option[zio.aws.datasync.model.EndpointType] =
      scala
        .Option(impl.endpointType())
        .map(value => zio.aws.datasync.model.EndpointType.wrap(value))
    override val privateLinkConfig
        : Option[zio.aws.datasync.model.PrivateLinkConfig.ReadOnly] = scala
      .Option(impl.privateLinkConfig())
      .map(value => zio.aws.datasync.model.PrivateLinkConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeAgentResponse
  ): zio.aws.datasync.model.DescribeAgentResponse.ReadOnly = new Wrapper(impl)
}
