package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLocationFsxLustreResponse(
    locationArn: Option[LocationArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreResponse = {
    import CreateLocationFsxLustreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationFsxLustreResponse.ReadOnly =
    zio.aws.datasync.model.CreateLocationFsxLustreResponse.wrap(buildAwsValue())
}
object CreateLocationFsxLustreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationFsxLustreResponse =
      zio.aws.datasync.model
        .CreateLocationFsxLustreResponse(locationArn.map(value => value))
    def locationArn: Option[LocationArn]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreResponse
  ) extends zio.aws.datasync.model.CreateLocationFsxLustreResponse.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreResponse
  ): zio.aws.datasync.model.CreateLocationFsxLustreResponse.ReadOnly =
    new Wrapper(impl)
}
