package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTasksResponse(
    tasks: Option[Iterable[zio.aws.datasync.model.TaskListEntry]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListTasksResponse = {
    import ListTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListTasksResponse
      .builder()
      .optionallyWith(
        tasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tasks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListTasksResponse.ReadOnly =
    zio.aws.datasync.model.ListTasksResponse.wrap(buildAwsValue())
}
object ListTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListTasksResponse =
      zio.aws.datasync.model.ListTasksResponse(
        tasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tasks: Option[List[zio.aws.datasync.model.TaskListEntry.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTasks: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TaskListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tasks", tasks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListTasksResponse
  ) extends zio.aws.datasync.model.ListTasksResponse.ReadOnly {
    override val tasks
        : Option[List[zio.aws.datasync.model.TaskListEntry.ReadOnly]] = scala
      .Option(impl.tasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.TaskListEntry.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListTasksResponse
  ): zio.aws.datasync.model.ListTasksResponse.ReadOnly = new Wrapper(impl)
}
