package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait TaskStatus {
  def unwrap: software.amazon.awssdk.services.datasync.model.TaskStatus
}
object TaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.TaskStatus
  ): zio.aws.datasync.model.TaskStatus = value match {
    case software.amazon.awssdk.services.datasync.model.TaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.TaskStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.datasync.model.TaskStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.datasync.model.TaskStatus.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.datasync.model.TaskStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.datasync.model.TaskStatus.UNAVAILABLE =>
      val r = UNAVAILABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskStatus =
      software.amazon.awssdk.services.datasync.model.TaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.datasync.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskStatus =
      software.amazon.awssdk.services.datasync.model.TaskStatus.AVAILABLE
  }
  case object CREATING extends zio.aws.datasync.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskStatus =
      software.amazon.awssdk.services.datasync.model.TaskStatus.CREATING
  }
  case object QUEUED extends zio.aws.datasync.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskStatus =
      software.amazon.awssdk.services.datasync.model.TaskStatus.QUEUED
  }
  case object RUNNING extends zio.aws.datasync.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskStatus =
      software.amazon.awssdk.services.datasync.model.TaskStatus.RUNNING
  }
  case object UNAVAILABLE extends zio.aws.datasync.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskStatus =
      software.amazon.awssdk.services.datasync.model.TaskStatus.UNAVAILABLE
  }
}
