package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait TaskQueueing {
  def unwrap: software.amazon.awssdk.services.datasync.model.TaskQueueing
}
object TaskQueueing {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.TaskQueueing
  ): zio.aws.datasync.model.TaskQueueing = value match {
    case software.amazon.awssdk.services.datasync.model.TaskQueueing.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.TaskQueueing.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.datasync.model.TaskQueueing.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.TaskQueueing {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskQueueing =
      software.amazon.awssdk.services.datasync.model.TaskQueueing.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.datasync.model.TaskQueueing {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskQueueing =
      software.amazon.awssdk.services.datasync.model.TaskQueueing.ENABLED
  }
  case object DISABLED extends zio.aws.datasync.model.TaskQueueing {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskQueueing =
      software.amazon.awssdk.services.datasync.model.TaskQueueing.DISABLED
  }
}
