package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeLocationSmbRequest(locationArn: LocationArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest = {
    import DescribeLocationSmbRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationSmbRequest.ReadOnly =
    zio.aws.datasync.model.DescribeLocationSmbRequest.wrap(buildAwsValue())
}
object DescribeLocationSmbRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationSmbRequest =
      zio.aws.datasync.model.DescribeLocationSmbRequest(locationArn)
    def locationArn: LocationArn
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest
  ) extends zio.aws.datasync.model.DescribeLocationSmbRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest
  ): zio.aws.datasync.model.DescribeLocationSmbRequest.ReadOnly = new Wrapper(
    impl
  )
}
