package zio.aws.datasync.model
import java.lang.Integer
import zio.aws.datasync.model.primitives.{HdfsServerPort, HdfsServerHostname}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class HdfsNameNode(
    hostname: HdfsServerHostname,
    port: HdfsServerPort
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.HdfsNameNode = {
    import HdfsNameNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.HdfsNameNode
      .builder()
      .hostname(HdfsServerHostname.unwrap(hostname): java.lang.String)
      .port(HdfsServerPort.unwrap(port): Integer)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.HdfsNameNode.ReadOnly =
    zio.aws.datasync.model.HdfsNameNode.wrap(buildAwsValue())
}
object HdfsNameNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.HdfsNameNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.HdfsNameNode =
      zio.aws.datasync.model.HdfsNameNode(hostname, port)
    def hostname: HdfsServerHostname
    def port: HdfsServerPort
    def getHostname: ZIO[Any, Nothing, HdfsServerHostname] =
      ZIO.succeed(hostname)
    def getPort: ZIO[Any, Nothing, HdfsServerPort] = ZIO.succeed(port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.HdfsNameNode
  ) extends zio.aws.datasync.model.HdfsNameNode.ReadOnly {
    override val hostname: HdfsServerHostname =
      zio.aws.datasync.model.primitives.HdfsServerHostname(impl.hostname())
    override val port: HdfsServerPort =
      zio.aws.datasync.model.primitives.HdfsServerPort(impl.port())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.HdfsNameNode
  ): zio.aws.datasync.model.HdfsNameNode.ReadOnly = new Wrapper(impl)
}
