package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait AgentStatus {
  def unwrap: software.amazon.awssdk.services.datasync.model.AgentStatus
}
object AgentStatus {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.AgentStatus
  ): zio.aws.datasync.model.AgentStatus = value match {
    case software.amazon.awssdk.services.datasync.model.AgentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.AgentStatus.ONLINE =>
      val r = ONLINE
      r
    case software.amazon.awssdk.services.datasync.model.AgentStatus.OFFLINE =>
      val r = OFFLINE
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.AgentStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AgentStatus =
      software.amazon.awssdk.services.datasync.model.AgentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ONLINE extends zio.aws.datasync.model.AgentStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AgentStatus =
      software.amazon.awssdk.services.datasync.model.AgentStatus.ONLINE
  }
  case object OFFLINE extends zio.aws.datasync.model.AgentStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AgentStatus =
      software.amazon.awssdk.services.datasync.model.AgentStatus.OFFLINE
  }
}
