package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class QopConfiguration(
    rpcProtection: Option[zio.aws.datasync.model.HdfsRpcProtection] = None,
    dataTransferProtection: Option[
      zio.aws.datasync.model.HdfsDataTransferProtection
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.QopConfiguration = {
    import QopConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.QopConfiguration
      .builder()
      .optionallyWith(rpcProtection.map(value => value.unwrap))(_.rpcProtection)
      .optionallyWith(dataTransferProtection.map(value => value.unwrap))(
        _.dataTransferProtection
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.QopConfiguration.ReadOnly =
    zio.aws.datasync.model.QopConfiguration.wrap(buildAwsValue())
}
object QopConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.QopConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.QopConfiguration =
      zio.aws.datasync.model.QopConfiguration(
        rpcProtection.map(value => value),
        dataTransferProtection.map(value => value)
      )
    def rpcProtection: Option[zio.aws.datasync.model.HdfsRpcProtection]
    def dataTransferProtection
        : Option[zio.aws.datasync.model.HdfsDataTransferProtection]
    def getRpcProtection
        : ZIO[Any, AwsError, zio.aws.datasync.model.HdfsRpcProtection] =
      AwsError.unwrapOptionField("rpcProtection", rpcProtection)
    def getDataTransferProtection: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.HdfsDataTransferProtection
    ] = AwsError.unwrapOptionField(
      "dataTransferProtection",
      dataTransferProtection
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.QopConfiguration
  ) extends zio.aws.datasync.model.QopConfiguration.ReadOnly {
    override val rpcProtection
        : Option[zio.aws.datasync.model.HdfsRpcProtection] = scala
      .Option(impl.rpcProtection())
      .map(value => zio.aws.datasync.model.HdfsRpcProtection.wrap(value))
    override val dataTransferProtection
        : Option[zio.aws.datasync.model.HdfsDataTransferProtection] = scala
      .Option(impl.dataTransferProtection())
      .map(value =>
        zio.aws.datasync.model.HdfsDataTransferProtection.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.QopConfiguration
  ): zio.aws.datasync.model.QopConfiguration.ReadOnly = new Wrapper(impl)
}
