package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{AgentArn, S3BucketArn, S3Subdirectory}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLocationS3Request(
    subdirectory: Option[S3Subdirectory] = None,
    s3BucketArn: S3BucketArn,
    s3StorageClass: Option[zio.aws.datasync.model.S3StorageClass] = None,
    s3Config: zio.aws.datasync.model.S3Config,
    agentArns: Option[Iterable[AgentArn]] = None,
    tags: Option[Iterable[zio.aws.datasync.model.TagListEntry]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationS3Request = {
    import CreateLocationS3Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationS3Request
      .builder()
      .optionallyWith(
        subdirectory.map(value =>
          S3Subdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .s3BucketArn(S3BucketArn.unwrap(s3BucketArn): java.lang.String)
      .optionallyWith(s3StorageClass.map(value => value.unwrap))(
        _.s3StorageClass
      )
      .s3Config(s3Config.buildAwsValue())
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateLocationS3Request.ReadOnly =
    zio.aws.datasync.model.CreateLocationS3Request.wrap(buildAwsValue())
}
object CreateLocationS3Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationS3Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationS3Request =
      zio.aws.datasync.model.CreateLocationS3Request(
        subdirectory.map(value => value),
        s3BucketArn,
        s3StorageClass.map(value => value),
        s3Config.asEditable,
        agentArns.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subdirectory: Option[S3Subdirectory]
    def s3BucketArn: S3BucketArn
    def s3StorageClass: Option[zio.aws.datasync.model.S3StorageClass]
    def s3Config: zio.aws.datasync.model.S3Config.ReadOnly
    def agentArns: Option[List[AgentArn]]
    def tags: Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getSubdirectory: ZIO[Any, AwsError, S3Subdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getS3BucketArn: ZIO[Any, Nothing, S3BucketArn] =
      ZIO.succeed(s3BucketArn)
    def getS3StorageClass
        : ZIO[Any, AwsError, zio.aws.datasync.model.S3StorageClass] =
      AwsError.unwrapOptionField("s3StorageClass", s3StorageClass)
    def getS3Config
        : ZIO[Any, Nothing, zio.aws.datasync.model.S3Config.ReadOnly] =
      ZIO.succeed(s3Config)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationS3Request
  ) extends zio.aws.datasync.model.CreateLocationS3Request.ReadOnly {
    override val subdirectory: Option[S3Subdirectory] = scala
      .Option(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.S3Subdirectory(value))
    override val s3BucketArn: S3BucketArn =
      zio.aws.datasync.model.primitives.S3BucketArn(impl.s3BucketArn())
    override val s3StorageClass: Option[zio.aws.datasync.model.S3StorageClass] =
      scala
        .Option(impl.s3StorageClass())
        .map(value => zio.aws.datasync.model.S3StorageClass.wrap(value))
    override val s3Config: zio.aws.datasync.model.S3Config.ReadOnly =
      zio.aws.datasync.model.S3Config.wrap(impl.s3Config())
    override val agentArns: Option[List[AgentArn]] = scala
      .Option(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val tags
        : Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.TagListEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationS3Request
  ): zio.aws.datasync.model.CreateLocationS3Request.ReadOnly = new Wrapper(impl)
}
