package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartTaskExecutionRequest(
    taskArn: TaskArn,
    overrideOptions: Option[zio.aws.datasync.model.Options] = None,
    includes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None,
    excludes: Option[Iterable[zio.aws.datasync.model.FilterRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest = {
    import StartTaskExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest
      .builder()
      .taskArn(TaskArn.unwrap(taskArn): java.lang.String)
      .optionallyWith(overrideOptions.map(value => value.buildAwsValue()))(
        _.overrideOptions
      )
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.StartTaskExecutionRequest.ReadOnly =
    zio.aws.datasync.model.StartTaskExecutionRequest.wrap(buildAwsValue())
}
object StartTaskExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.StartTaskExecutionRequest =
      zio.aws.datasync.model.StartTaskExecutionRequest(
        taskArn,
        overrideOptions.map(value => value.asEditable),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskArn: TaskArn
    def overrideOptions: Option[zio.aws.datasync.model.Options.ReadOnly]
    def includes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def excludes: Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def getTaskArn: ZIO[Any, Nothing, TaskArn] = ZIO.succeed(taskArn)
    def getOverrideOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.Options.ReadOnly] =
      AwsError.unwrapOptionField("overrideOptions", overrideOptions)
    def getIncludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("includes", includes)
    def getExcludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludes", excludes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest
  ) extends zio.aws.datasync.model.StartTaskExecutionRequest.ReadOnly {
    override val taskArn: TaskArn =
      zio.aws.datasync.model.primitives.TaskArn(impl.taskArn())
    override val overrideOptions
        : Option[zio.aws.datasync.model.Options.ReadOnly] = scala
      .Option(impl.overrideOptions())
      .map(value => zio.aws.datasync.model.Options.wrap(value))
    override val includes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.includes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
    override val excludes
        : Option[List[zio.aws.datasync.model.FilterRule.ReadOnly]] = scala
      .Option(impl.excludes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.FilterRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest
  ): zio.aws.datasync.model.StartTaskExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
