package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{TagValue, TaskArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TaskListEntry(
    taskArn: Option[TaskArn] = None,
    status: Option[zio.aws.datasync.model.TaskStatus] = None,
    name: Option[TagValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskListEntry = {
    import TaskListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskListEntry
      .builder()
      .optionallyWith(
        taskArn.map(value => TaskArn.unwrap(value): java.lang.String)
      )(_.taskArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskListEntry.ReadOnly =
    zio.aws.datasync.model.TaskListEntry.wrap(buildAwsValue())
}
object TaskListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskListEntry =
      zio.aws.datasync.model.TaskListEntry(
        taskArn.map(value => value),
        status.map(value => value),
        name.map(value => value)
      )
    def taskArn: Option[TaskArn]
    def status: Option[zio.aws.datasync.model.TaskStatus]
    def name: Option[TagValue]
    def getTaskArn: ZIO[Any, AwsError, TaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskListEntry
  ) extends zio.aws.datasync.model.TaskListEntry.ReadOnly {
    override val taskArn: Option[TaskArn] = scala
      .Option(impl.taskArn())
      .map(value => zio.aws.datasync.model.primitives.TaskArn(value))
    override val status: Option[zio.aws.datasync.model.TaskStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.datasync.model.TaskStatus.wrap(value))
    override val name: Option[TagValue] = scala
      .Option(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskListEntry
  ): zio.aws.datasync.model.TaskListEntry.ReadOnly = new Wrapper(impl)
}
