package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.NonNegativeDouble
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MaxP95Performance(
    iopsRead: Optional[NonNegativeDouble] = Optional.Absent,
    iopsWrite: Optional[NonNegativeDouble] = Optional.Absent,
    iopsOther: Optional[NonNegativeDouble] = Optional.Absent,
    iopsTotal: Optional[NonNegativeDouble] = Optional.Absent,
    throughputRead: Optional[NonNegativeDouble] = Optional.Absent,
    throughputWrite: Optional[NonNegativeDouble] = Optional.Absent,
    throughputOther: Optional[NonNegativeDouble] = Optional.Absent,
    throughputTotal: Optional[NonNegativeDouble] = Optional.Absent,
    latencyRead: Optional[NonNegativeDouble] = Optional.Absent,
    latencyWrite: Optional[NonNegativeDouble] = Optional.Absent,
    latencyOther: Optional[NonNegativeDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.MaxP95Performance = {
    import MaxP95Performance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.MaxP95Performance
      .builder()
      .optionallyWith(
        iopsRead.map(value => NonNegativeDouble.unwrap(value): java.lang.Double)
      )(_.iopsRead)
      .optionallyWith(
        iopsWrite.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.iopsWrite)
      .optionallyWith(
        iopsOther.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.iopsOther)
      .optionallyWith(
        iopsTotal.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.iopsTotal)
      .optionallyWith(
        throughputRead.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.throughputRead)
      .optionallyWith(
        throughputWrite.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.throughputWrite)
      .optionallyWith(
        throughputOther.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.throughputOther)
      .optionallyWith(
        throughputTotal.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.throughputTotal)
      .optionallyWith(
        latencyRead.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.latencyRead)
      .optionallyWith(
        latencyWrite.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.latencyWrite)
      .optionallyWith(
        latencyOther.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.latencyOther)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.MaxP95Performance.ReadOnly =
    zio.aws.datasync.model.MaxP95Performance.wrap(buildAwsValue())
}
object MaxP95Performance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.MaxP95Performance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.MaxP95Performance =
      zio.aws.datasync.model.MaxP95Performance(
        iopsRead.map(value => value),
        iopsWrite.map(value => value),
        iopsOther.map(value => value),
        iopsTotal.map(value => value),
        throughputRead.map(value => value),
        throughputWrite.map(value => value),
        throughputOther.map(value => value),
        throughputTotal.map(value => value),
        latencyRead.map(value => value),
        latencyWrite.map(value => value),
        latencyOther.map(value => value)
      )
    def iopsRead: Optional[NonNegativeDouble]
    def iopsWrite: Optional[NonNegativeDouble]
    def iopsOther: Optional[NonNegativeDouble]
    def iopsTotal: Optional[NonNegativeDouble]
    def throughputRead: Optional[NonNegativeDouble]
    def throughputWrite: Optional[NonNegativeDouble]
    def throughputOther: Optional[NonNegativeDouble]
    def throughputTotal: Optional[NonNegativeDouble]
    def latencyRead: Optional[NonNegativeDouble]
    def latencyWrite: Optional[NonNegativeDouble]
    def latencyOther: Optional[NonNegativeDouble]
    def getIopsRead: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("iopsRead", iopsRead)
    def getIopsWrite: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("iopsWrite", iopsWrite)
    def getIopsOther: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("iopsOther", iopsOther)
    def getIopsTotal: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("iopsTotal", iopsTotal)
    def getThroughputRead: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("throughputRead", throughputRead)
    def getThroughputWrite: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("throughputWrite", throughputWrite)
    def getThroughputOther: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("throughputOther", throughputOther)
    def getThroughputTotal: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("throughputTotal", throughputTotal)
    def getLatencyRead: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("latencyRead", latencyRead)
    def getLatencyWrite: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("latencyWrite", latencyWrite)
    def getLatencyOther: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("latencyOther", latencyOther)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.MaxP95Performance
  ) extends zio.aws.datasync.model.MaxP95Performance.ReadOnly {
    override val iopsRead: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.iopsRead())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeDouble(value))
    override val iopsWrite: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.iopsWrite())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeDouble(value))
    override val iopsOther: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.iopsOther())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeDouble(value))
    override val iopsTotal: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.iopsTotal())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeDouble(value))
    override val throughputRead: Optional[NonNegativeDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputRead())
        .map(value =>
          zio.aws.datasync.model.primitives.NonNegativeDouble(value)
        )
    override val throughputWrite: Optional[NonNegativeDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputWrite())
        .map(value =>
          zio.aws.datasync.model.primitives.NonNegativeDouble(value)
        )
    override val throughputOther: Optional[NonNegativeDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputOther())
        .map(value =>
          zio.aws.datasync.model.primitives.NonNegativeDouble(value)
        )
    override val throughputTotal: Optional[NonNegativeDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputTotal())
        .map(value =>
          zio.aws.datasync.model.primitives.NonNegativeDouble(value)
        )
    override val latencyRead: Optional[NonNegativeDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latencyRead())
        .map(value =>
          zio.aws.datasync.model.primitives.NonNegativeDouble(value)
        )
    override val latencyWrite: Optional[NonNegativeDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latencyWrite())
        .map(value =>
          zio.aws.datasync.model.primitives.NonNegativeDouble(value)
        )
    override val latencyOther: Optional[NonNegativeDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latencyOther())
        .map(value =>
          zio.aws.datasync.model.primitives.NonNegativeDouble(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.MaxP95Performance
  ): zio.aws.datasync.model.MaxP95Performance.ReadOnly = new Wrapper(impl)
}
