package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{PtolemyPassword, PtolemyUsername}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Credentials(
    username: PtolemyUsername,
    password: PtolemyPassword
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.Credentials = {
    import Credentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.Credentials
      .builder()
      .username(PtolemyUsername.unwrap(username): java.lang.String)
      .password(PtolemyPassword.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.Credentials.ReadOnly =
    zio.aws.datasync.model.Credentials.wrap(buildAwsValue())
}
object Credentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.Credentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.Credentials =
      zio.aws.datasync.model.Credentials(username, password)
    def username: PtolemyUsername
    def password: PtolemyPassword
    def getUsername: ZIO[Any, Nothing, PtolemyUsername] = ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, PtolemyPassword] = ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.Credentials
  ) extends zio.aws.datasync.model.Credentials.ReadOnly {
    override val username: PtolemyUsername =
      zio.aws.datasync.model.primitives.PtolemyUsername(impl.username())
    override val password: PtolemyPassword =
      zio.aws.datasync.model.primitives.PtolemyPassword(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.Credentials
  ): zio.aws.datasync.model.Credentials.ReadOnly = new Wrapper(impl)
}
