package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait ObjectVersionIds {
  def unwrap: software.amazon.awssdk.services.datasync.model.ObjectVersionIds
}
object ObjectVersionIds {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.ObjectVersionIds
  ): zio.aws.datasync.model.ObjectVersionIds = value match {
    case software.amazon.awssdk.services.datasync.model.ObjectVersionIds.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.ObjectVersionIds.INCLUDE =>
      val r = INCLUDE
      r
    case software.amazon.awssdk.services.datasync.model.ObjectVersionIds.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.ObjectVersionIds {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ObjectVersionIds =
      software.amazon.awssdk.services.datasync.model.ObjectVersionIds.UNKNOWN_TO_SDK_VERSION
  }
  case object INCLUDE extends zio.aws.datasync.model.ObjectVersionIds {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ObjectVersionIds =
      software.amazon.awssdk.services.datasync.model.ObjectVersionIds.INCLUDE
  }
  case object NONE extends zio.aws.datasync.model.ObjectVersionIds {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ObjectVersionIds =
      software.amazon.awssdk.services.datasync.model.ObjectVersionIds.NONE
  }
}
